let t_abonos;

let active_row=false;
let active_obj=false;

document.addEventListener('DOMContentLoaded', function(){
    //DataTables Abonos Ventas - Ajax
    t_abonos = $('#t_abonos').DataTable({
        "aPreocesing": true,
        "aServerSide": false,
        "ajax": {
            "url": "" + base_url + "creditoventas/listar_abonos",
            "dataSrc": ""
        },
        "columns": [{
                "data": "id"
            },
            {
                "data": "rec_numero"
            },            
            {
                "data": "fecha"
            },
            {
                "data": "monto"
            },
            {
                "data": "nombre"
            },
            {
                "data": "referencias"
            },
            {
                "data": "metodo_pago"
            },
            {
                "data": "id_credito"
            },
            {
                "data": "estado",
                "render": function ( data, type, row, meta ) {
                    //console.log(row['diasdiferencia'],data)

                    if(row['estado']==2){
                        return `<span class="badge badge-danger">Anulado</span>`;
                    } else {
                        return `<span class="badge badge-success">Emitido</span>`;
                    }

                },                
            },
            {
                "data": "observaciones"
            }
        ],
        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [0, "desc"]
        ]
    });

    t_abonos.on( 'draw', function () {
        $('#t_abonos tbody tr').removeClass('selected');
        activo_buttons(false)
        //frmCliente()
        //btnEditarCli(15)
    } );

    $('#t_abonos tbody').on( 'click', 'tr', function (e) {
        let classList = e.currentTarget.classList;
       
        if (classList.contains('selected')) {
            classList.remove('selected');
        }
        else {
            t_abonos.rows('.selected').nodes().each((row) => row.classList.remove('selected'));
            classList.add('selected');
        }
        activo_buttons( t_abonos.row( this ).data()  );
    } );

    $('#min').change(function (e) {
        t_abonos.draw();
    });
    //Busqueda por Rango de Fechas DataTables - Hasta
    $('#max').change(function (e) {
        t_abonos.draw();
    }); 
})

function autoriza_abono(id) {

    const http = new XMLHttpRequest();
    const url = base_url + "creditoventas/autorizaAbono/"+ id;

    http.open("GET", url);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);

            console.log(res)
            t_abonos.ajax.reload();
        }
    }
}

function activo_buttons(obj)
{
    active_obj=obj;
    active_row=active_obj.id;

    if($('#t_abonos tbody tr.selected').length==0)
    {
        active_row=false;
        $('BUTTON.btn-toolbar-status').attr('disabled', 'disabled');
        $('BUTTON.btn-recuperar').hide();
        $('BUTTON.btn-eliminar').show();            
    } else {
        $('BUTTON.btn-toolbar-status').removeAttr('disabled');
        
        if(active_obj.estado_txt==='activo') {
            $('BUTTON.btn-recuperar').hide();
            $('BUTTON.btn-eliminar').show();
        } else {
            $('BUTTON.btn-recuperar').show();
            $('BUTTON.btn-eliminar').hide();
        }            
    }
}

function rechaza_abono(id) {

    const http = new XMLHttpRequest();
    const url = base_url + "creditoventas/rechazaAbono/"+ id;

    http.open("GET", url);
    http.send();
    http.onreadystatechange = function () {

        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            t_abonos.ajax.reload();
        }
    }
}