<?php
class Marcas extends Controller
{
    private $id_usuario;

    public function __construct()
    {
        session_start();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        parent::__construct();
        $this->id_usuario = $_SESSION['id_usuario'];
    }

    public function index()
    {
        $data['scripts'] = array(
            array('script' => 'pages/marcas.js')
        );
        $this->views->getView('productos', "marcas", $data);
    }

    public function listar()
    {
        $data = $this->model->getMarcas();
        for ($i = 0; $i < count($data); $i++) {
            $data[$i]['editar'] = '';
            if ($data[$i]['estado'] == 1) {
                $data[$i]['editar'] = '<button class="btn btn-primary" type="button" onclick="btnEditarMar(' . $data[$i]['id'] . ');"><i class="fas fa-edit"></i></button>';
                $data[$i]['eliminar'] = '<button class="btn btn-danger" type="button" onclick="btnEliminarMar(' . $data[$i]['id'] . ');"><i class="fas fa-trash-alt"></i></button>';
                $data[$i]['estado'] = '<span class="badge badge-success">Activo</span>';
                $data[$i]['estado_txt'] = 'activo';
            } else {
                $data[$i]['eliminar'] = '<button class="btn btn-success" type="button" onclick="btnReingresarMar(' . $data[$i]['id'] . ');"><i class="fas fa-circle"></i></button>';
                $data[$i]['estado'] = '<span class="badge badge-danger">Inactivo</span>';
                $data[$i]['estado_txt'] = 'inactivo';
            }
        }
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function registrar()
    {
        $marca = strClean($_POST['marca']);
        $id = strClean($_POST['id']);
        if (empty($marca)) {
            $msg = array('msg' => 'La marca es requerido', 'icono' => 'error');
        } else {
            if ($id == "") {
                $data = $this->model->registrarMar($marca);
                if ($data == "ok") {
                    $msg = array('msg' => 'Marca registrado', 'icono' => 'success');
                } else if ($data == "existe") {
                    $msg = array('msg' => 'La Marca ya existe', 'icono' => 'warning');
                } else {
                    $msg = array('msg' => 'Error al registrar la Marca', 'icono' => 'error');
                }
            } else {
                $data = $this->model->modificarMar($marca, $id);
                if ($data == "modificado") {
                    $msg = array('msg' => 'Marca modificado con éxito', 'icono' => 'success');
                } else {
                    $msg = "Error al modificar el Marca";
                    $msg = array('msg' => 'Error al modificar la Marca', 'icono' => 'error');
                }
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function editar($id)
    {
        $data = $this->model->editarMar($id);
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function eliminar($id)
    {
        $data = $this->model->accionMar(0, $id);
        if ($data == 1) {
            $msg = array('msg' => 'Marca dado de baja', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al eliminar la Marca', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function reingresar($id)
    {
        $data = $this->model->accionMar(1, $id);
        if ($data == 1) {
            $msg = array('msg' => 'Marca reingresado', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al reingresar la Marca', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
}
