<?php
class Pedidos extends Controller
{
    private $id_usuario;

    public function __construct()
    {
        session_start();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        parent::__construct();
        $this->id_usuario = $_SESSION['id_usuario'];
    }
    public function index()
    {
        $data['scripts'] = array(
            array('script' => 'jquery-ui.min.js'),
            array('script' => 'pages/ventas.js')
        );
        $this->views->getView('ventas', "index", $data);
    }

    public function buscarProducto()
    {
        $data = $this->model->buscarProducto(strClean($_GET['pro']));
        $datos = array();
        foreach ($data as $row) {
            $data = array();;
            $data['id'] = $row['id'];
            $data['label'] = $row['codigo'] . ' - ' . $row['descripcion'];
            $data['cantidad'] = $row['cantidad'];
            $data['value'] = $row['codigo'];
            $data['value_alter'] = $row['codigo_alter'];
            
            $data['precio'] = $row['precio_venta'];
            $data['foto'] = $row['foto'];
            $data['descripcion'] = $row['descripcion'];
            array_push($datos, $data);
        }
        echo json_encode($datos, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function ingresar($id_pro)
    {
        $datos = $this->model->getProducto($id_pro);
        $precio = $datos['precio_venta'];
        $cantidad = 1;
        $comprobar = $this->model->getComprobar($id_pro, $this->id_usuario, 'detalle_temp');
        $cantidad_dis = $datos['cantidad'];
        if ($cantidad_dis < $cantidad) {
            $msg = array('msg' => 'No hay Stock, te quedan ' . $cantidad_dis, 'icono' => 'warning');
        } else {
            if (empty($comprobar)) {
                $sub_total = $precio * $cantidad;
                $data = $this->model->registrarDetalle($id_pro, $this->id_usuario, $precio, $cantidad, $sub_total);
                if ($data == "ok") {
                    $msg = array('msg' => 'Producto ingresado', 'icono' => 'success');
                } else {
                    $msg = array('msg' => 'Error al ingresar el producto', 'icono' => 'error');
                }
            } else {
                $msg = array('msg' => 'El producto ya esta agregado', 'icono' => 'error');
            }
        }
        
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function listar($table)
    {
        $data['detalle'] = $this->model->getDetalle($this->id_usuario, $table);
        $data['total_pagar'] = $this->model->calcularTotal($this->id_usuario, $table);
        
        $data['series'] = $this->model->getSeries();
        $data['vendedores'] = $this->model->getVendedores();
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function delete($id)
    {
        $data = $this->model->deleteDetalle($id, 'detalle_temp');
        if ($data == 'ok') {
            $msg = array('msg' => 'Producto Eliminado', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al eliminar el producto', 'icono' => 'error');
        }
        echo json_encode($msg);
        die();
    }

    //Precio producto
    public function precioProducto($datos)
    {
        $array = explode(",", $datos);
        $id = $array[0];
        $precio = $array[1];
        if (is_numeric($id) && is_numeric($precio)) {
            if ($precio > '') {
                $data = $this->model->actualizarPrecio('detalle_temp', $precio, $id);
                if ($data == 'ok') {
                    $msg = array('msg' => 'Ingresado', 'icono' => 'success');
                } else {
                    $msg = array('msg' => 'Error al agregar la precio', 'icono' => 'error');
                }
            } else {
                $msg = array('msg' => 'La cantidad debe ser mayor a 0', 'icono' => 'error');
            }
        } else {
            $msg = array('msg' => 'Ingrese un número valido', 'icono' => 'warning');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }   

    public function cantidadVenta($datos)
    {
        $array = explode(",", $datos);
        $id = $array[0];
        $cant = $array[1];
        if (is_numeric($id) && is_numeric($cant)) {
            if ($cant > 0) {
                $stock = $this->model->verificarStock('detalle_temp', $id);
                if ($cant <= $stock['cantidad']) {
                    $data = $this->model->actualizarCantidad('detalle_temp', $cant, $id);
                    if ($data == 'ok') {
                        $msg = array('msg' => 'Ingresado', 'icono' => 'success');
                    } else {
                        $msg = array('msg' => 'Error al agregar la cantidad', 'icono' => 'error');
                    }
                } else {
                    $this->model->actualizarCantidad('detalle_temp', $stock['cantidad'], $id);
                    $msg = array('msg' => 'Stock Disponible solo ' . $stock['cantidad'], 'icono' => 'error');
                }
            } else {
                $msg = array('msg' => 'La cantidad debe ser mayor a 0', 'icono' => 'error');
            }
        } else {
            $msg = array('msg' => 'Ingrese un número valido', 'icono' => 'warning');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }


    //Historial Pedidos Normal
    /*
    public function historial()
    {
        $data['scripts'] = array(
            array('script' => 'fechas.js'),
            array('script' => 'sum().js'),
            array('script' => 'pages/historial_ventas.js')
        );
        $this->views->getView('pedidos', "historial", $data);
    }
    */

    //Historial Pedidos Server Side
    public function historial_ss()
    {
        $data['scripts'] = array(
            array('script' => 'fechas.js'),
            array('script' => 'sum().js'),
            array('script' => 'pages/historial_pedidos_ss.js')
        );
        $this->views->getView('pedidos', "historial_ss", $data);
    }

    
    /*Listar pedidos Normal
    public function listar_pedidos()
    {
        $data = $this->model->getHistorial('ventas', $this->id_usuario);

        for ($i = 0; $i < count($data); $i++) {

            $url = base_url . 'ventas/generarPdf/' . $data[$i]['id'];
            
            //$data[$i]['sucursal']='Sucursal 2';
            //$data[$i]['vendedor']='Vendedor 2 y apellido';

            if ($data[$i]['estado'] == 'F') {
                $data[$i]['estado'] = '<span class="badge badge-success">Firmada</span>';
                $data[$i]['acciones'] = '<div class="d-flex">
                    <a href="' . $url . '" target="_blank" class="btn btn-outline-danger"><i class="fas fa-file-pdf"></i></a>
                    <button class="btn btn-outline-warning" type="button" onclick="btnAnular(' . $data[$i]['id'] . ');"><i class="fas fa-ban"></i></button>
                    <div/>';
                $data[$i]['estado_txt']='firmada';
            } else if ($data[$i]['estado'] == 'E') {
                $data[$i]['estado'] = '<span class="badge badge-warning">Emitida</span>';
                $data[$i]['acciones'] = '<div class="d-flex">
                    <a href="' . $url . '" target="_blank" class="btn btn-outline-danger"><i class="fas fa-file-pdf"></i></a>
                    <button class="btn btn-outline-warning" type="button" onclick="btnAnular(' . $data[$i]['id'] . ');"><i class="fas fa-ban"></i></button>
                    <div/>';
                $data[$i]['estado_txt']='emitida';
            } else if ($data[$i]['estado'] == 'A') {
                $data[$i]['estado'] = '<span class="badge badge-danger">Anulado</span>';
                $data[$i]['acciones'] = '<div>
                    <a href="' . $url . '" target="_blank" class="btn btn-outline-danger"><i class="fas fa-file-pdf"></i></a>
                    <div/>';
                $data[$i]['estado_txt']='anulado';
            }

            $data[$i]['nombre']=(!is_null($data[$i]['nombre']))?trim(iso8859_to_utf8($data[$i]['nombre'])):'';
        }

        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        
        //var_dump(json_encode($data, JSON_UNESCAPED_UNICODE));

        die();
    }
    */


    public function listar_pedidos_ss()
    {
        $data = $this->model->getHistorial_ss('ventas', $this->id_usuario);

        $posTipo=5;
        $posEstado=6;

        for ($i = 0; $i < count($data['aaData']); $i++) {

            if ($data['aaData'][$i][$posEstado] == 'P') {
                $data['aaData'][$i][$posEstado] = '<span class="badge badge-warning" style="background-color: #8e999b;">PENDIENTE</span>';
            } else if ($data['aaData'][$i][$posEstado] == 'E') {
                $data['aaData'][$i][$posEstado] = '<span class="badge badge-warning">EMITIDO</span>';
            } else if ($data['aaData'][$i][$posEstado] == 'A') {
                $data['aaData'][$i][$posEstado] = '<span class="badge badge-primary">AUTORIZADO</span>';
            } else if ($data['aaData'][$i][$posEstado] == 'I') {
                $data['aaData'][$i][$posEstado] = '<span class="badge badge-primary" style="background-color: #196faa;">IMPRESO</span>';
            } else if ($data['aaData'][$i][$posEstado] == 'F') {
                $data['aaData'][$i][$posEstado] = '<span class="badge badge-primary" style="background-color: #313541;">FACTURADO</span>';
            } else if ($data['aaData'][$i][$posEstado] == 'D') {
                $data['aaData'][$i][$posEstado] = '<span class="badge badge-primary" style="background-color: #6faf4a;">DESPACHADO</span>';
            } else if ($data['aaData'][$i][$posEstado] == 'R') {
                $data['aaData'][$i][$posEstado] = '<span class="badge badge-light" style="background-color: #aaa9ae;">RETENIDO</span>';
            } else if ($data['aaData'][$i][$posEstado] == 'X') {
                $data['aaData'][$i][$posEstado] = '<span class="badge badge-danger">ANULADO</span>';
            }

            if ($data['aaData'][$i][$posTipo] == 'P') {
                $data['aaData'][$i][$posTipo] = '<span class="badge badge-success">PEDIDO</span>';
            } else if ($data['aaData'][$i][$posTipo] == 'C') {
                $data['aaData'][$i][$posTipo] = '<span class="badge badge-warning">COMPLEMENTO</span>';
            } else if ($data['aaData'][$i][$posTipo] == 'R') {
                $data['aaData'][$i][$posTipo] = '<span class="badge badge-primary">RAPIDITO</span>';
            }

            //$data['aaData'][$i][2]=(!is_null($data['aaData'][$i][2]))?trim(iso8859_to_utf8($data['aaData'][$i][2])):'';
        }

        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function cambiarEstadoPedido()
    {
        $this->model->modificarEstadoPedido($_POST['id'], $_POST['estado']);
        echo json_encode('OK', JSON_UNESCAPED_UNICODE);
        die();
    }

    public function cambiarTipoPedido()
    {
        $this->model->modificarTipoPedido($_POST['id'], $_POST['tipo']);
        echo json_encode('OK', JSON_UNESCAPED_UNICODE);
        die();
    }

    public function generarVenta()
    {
        $caja = $this->model->verficarCaja($this->id_usuario);
        if (empty($caja)) {
            $msg = array('msg' => 'La caja esta cerrada', 'icono' => 'warning');
        } else {
            $id_cliente = $_POST['id_cliente'];
            $serie = $_POST['serie'];
            $anotacion = $_POST['anotacion'];
            $vendedor = $_POST['id_vendedor'];
            //$forma = ($_POST['contado']) ? 1 : 2;
            $forma = ($_POST['contado']==='true') ? 1 : 2;
            $tipodoc = $this->model->getTipoDoc($serie);
            $data = $this->model->getDetalle($this->id_usuario, 'detalle_temp');
            $pagar = $this->model->calcularTotal($this->id_usuario, 'detalle_temp');
            $fecha = $_POST['fecha'];
            $hora = date('H:i.s');

            $nombre_cliente = $_POST['nombre_cliente'];
            $tipoid = $_POST['tipoid'];
            $nit = $_POST['nit'];
            $direccion = $_POST['direccion'];
            $mostrador = $_POST['mostrador'];

            /*if($mostrador=='0')
            {
                $msg = array('msg' => 'Cliente '.var_export($direccion,true), 'folio' => 1, 'icono' => 'success');
            } else {
                $msg = array('msg' => 'Cliente Mostrador '.var_export($direccion,true), 'folio' => 1, 'icono' => 'success');
            }*/

            $venta = $this->model->insertarVenta($this->id_usuario, $pagar['total'], $id_cliente, $fecha, $hora, $forma,$serie, $anotacion,$vendedor,$tipodoc);

            if($mostrador=='0')
            {
                $this->model->actualizarClienteVenta($venta);
            } else {
                $this->model->actualizarClienteVentaMostrador($venta,$nombre_cliente,$tipoid,$nit,$direccion);
            }

            /*$msg = array('msg' => var_export($venta,true), 'folio' => 1, 'icono' => 'success');
            echo json_encode($msg, JSON_UNESCAPED_UNICODE);
            return;*/
            
            $this->model->actualizarUltimaFechaVenta($id_cliente);

            if ($venta > 0) {
                if ($forma == 2) {
                    //$this->model->insertarCredito($venta, $pagar['total'], $id_cliente, $pagar['total'], $fecha, $this->id_usuario);
                    $this->model->insertarCredito($venta, $pagar['total'], $id_cliente, $fecha, $this->id_usuario);
                }
                foreach ($data as $row) {
                    $id_pro = $row['id_producto'];
                    $cantidad = $row['cantidad'];
                    $desc = $row['descuento'];
                    $precio = $row['precio'];
                    $sub_total = $row['sub_total'];

                    $this->model->registrar('detalle_ventas', $venta, $id_pro, $cantidad, $desc, $precio, $sub_total);
                    $stock = $this->model->getProducto($id_pro);
                    $total_cantidad = $stock['cantidad'] - $row['cantidad'];
                    $this->model->actualizarStock($total_cantidad, $stock['id']);
                }
                $eliminar = $this->model->eliminarTemp($this->id_usuario, 'detalle_temp');
                $this->model->actualizarDescripciones($venta);
                $this->model->actualizarProductosFechaCompra($venta);
                //$this->model->actualizarTotalesImpuestosDetalle($venta);
                if ($eliminar == 'ok') {
                    $msg = array('msg' => 'Venta Generada', 'folio' => $venta, 'icono' => 'success');

                }
            } else {
                $msg = array('msg' => 'Error al generar la venta', 'icono' => 'error');
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function descuentoVenta($datos)
    {
        $array = explode(",", $datos);
        $id = $array[0];
        $desc = $array[1];
        if (is_numeric($id) && is_numeric($desc)) {
            $data = $this->model->actualizarDescuento('detalle_temp', $desc, $id);
            if ($data == 'ok') {
                $msg = array('msg' => 'Descuento Agregado', 'icono' => 'success');
            } else {
                $msg = array('msg' => 'Error al agregar el descuento', 'icono' => 'error');
            }
        } else {
            $msg = array('msg' => 'Ingrese un número valido', 'icono' => 'warning');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }


    public function generarPedidoPdf($number)
    {
        list($folio,$cupon)=explode(",",$number);

        $pedido = $this->model->getPedido($folio);
        $empresa = $this->model->getEmpresa();
        
        $cupon = ($cupon=='NC') ? false : true;

        $telefono = trim($empresa['telefono']);
        if (!empty($telefono)) {
            $telefono = preg_replace('/[^0-9]/', '', $telefono);
            if (strlen($telefono) == 8) {
                $data['telefono'] = substr($telefono, 0, 4) . ' ' . substr($telefono, 4, 4);
            } else {
                $data['telefono'] = $telefono;
            }
        } else {
            $data['telefono'] = '';
        }

        $logoPath = 'Assets/img/logo-factura.png';
        $logoBase64 = '';
        if (file_exists($logoPath)) {
            $logoData = base64_encode(file_get_contents($logoPath));
            $data['logoBase64'] = 'data:image/png;base64,' . $logoData;
        }

        $css = '<style>
        body { font-family: Verdana; }
        div.area-logo { width: 95mm; height: 15mm; float: left; }
        div.area-pedido { width: 30mm; height: 15mm; float: left; margin-left: 5mm; }
        div.area-barcode { width: 50mm; height: 15mm; float: right; }
        .numero-pedido { font-weight: bold; font-size: 9pt; }
        .tabla-productos tr:nth-child(odd) { background-color: #eee; }
        .tabla-productos th { background-color: #000000;color: #ffffff; font-weight: bold; }
        .tabla-bordered { border: 1px solid #000; }
        .tabla-bordered th, .tabla-bordered td { border: 1px solid #000; }
        .footer-pagina { font-size: 8pt; color: #666; border-top: 1px dashed #ccc; height: 85mm; }
        </style>';

        // Datos
        $data['numero_pedido'] = $folio;
        $data['codigo_cliente'] = $pedido['enc_cliente'];
        $data['nombre_cliente'] = $pedido['enc_nom'];
        $data['nit_cliente'] = $pedido['enc_nit'];
        $data['direccion_cliente'] = $pedido['enc_dir'];
        $data['estado'] = $pedido['enc_estado'];
        $data['vendedor'] = $pedido['enc_vend'];
        $data['fecha'] = dateToSpanish($pedido['enc_fecha'],true);
        $data['detalles'] = $pedido['detalle'];

        $data['destinatario'] = $pedido['enc_nom'];
        $data['direccion'] = $pedido['enc_dir'];

        $limite_destinatario = 27;
        if (strlen($data['destinatario']) > $limite_destinatario) {
            $data['destinatario_parte1'] = substr($data['destinatario'], 0, $limite_destinatario);
            $data['destinatario_parte2'] = substr($data['destinatario'], $limite_destinatario);
        } else {
            $data['destinatario_parte1'] = $data['destinatario'];
            $data['destinatario_parte2'] = '&nbsp;';
        }

        $limite_direccion = 33;
        if (strlen($data['direccion']) > $limite_direccion) {
            $data['direccion_parte1'] = substr($data['direccion'], 0, $limite_direccion);
            $data['direccion_parte2'] = substr($data['direccion'], $limite_direccion);
        } else {
            $data['direccion_parte1'] = $data['direccion'];
            $data['direccion_parte2'] = '&nbsp;';
        }

        ob_start();

        $html = $this->views->getView('pedidos', (($cupon===true) ? "formato_pedido_cupon" : "formato_pedido"), $data);

        echo $html;
        $html = ob_get_clean();

        require_once 'vendor/autoload.php';

        $margin_footer = ($cupon===true) ? 92 : 6;

        $config = [
            'mode' => 'utf-8',
            'format' => 'Letter',
            'default_font_size' => 10,
            'default_font' => 'Verdana',
            'margin_left' => 5,
            'margin_right' => 5,
            'margin_top' => 19,
            'margin_bottom' => $margin_footer,
            'margin_header' => 3,
            'margin_footer' => 3,
            'orientation' => 'P'
        ];

        $mpdf = new \Mpdf\Mpdf($config);

        $mpdf->SetDisplayMode('fullpage');
        $mpdf->SetTitle('Factura - Distinsa');
        $mpdf->SetAuthor('Distinsa');
        $mpdf->SetCreator('Sistema de Facturación');

        $mpdf->WriteHTML($css, \Mpdf\HTMLParserMode::HEADER_CSS);
        $mpdf->WriteHTML($html, \Mpdf\HTMLParserMode::HTML_BODY);

        $mpdf->Output('Pedido-'.$folio.'.pdf', \Mpdf\Output\Destination::INLINE);
    }

    //IMPRESION ANTERIOR PDF LIBRERIA VIEJA
    /*
    public function generarPdf($folio)
    {

       $data['estilo'] = 'reporte.css';
       $data['logo_tamanio'] = 250;
       $data['empresa'] = $this->model->getEmpresa();
       $data['venta'] = $this->model->getVenta($folio);
       $data['detalle'] = $this->model->detalleVentas($folio);
       $data['sucursal'] = $this->model->getSucursal($folio);

       //var_dump($data);

        $number = $data['venta']['total'];
        $integerPart = floor($number);
        $decimalPart = $number - $integerPart;
        $data['total_letras']=strtoupper(convertir($integerPart).' CON '.$decimalPart.'/100 QUETZALES');


        //Cambiar esto, me imagino hay que copiar el controller qr de divemosa hacia aca
        $feedUrl = 'https://ad.divemosa.com/inventario/Controllers/qr/index.php?numero='.$data['venta']['autorizacion'].'&receptor='.$data['venta']['nitcliente'].'&monto='.$data['venta']['total'];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $feedUrl);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    
        $rawFeed = curl_exec($ch);
        $error   = curl_error($ch);
        curl_close($ch);

        $data['qr']='data:image/png;base64,'.base64_encode($rawFeed);

        ob_start();

        //$data['venta']["tipodoc"] FACT | FCAM

//        if($data['venta']["tipodoc"]=='FACT')
//        {
//            $html = $this->views->getView('ventas', "formato_fact", $data);
//        } else {
//            $html = $this->views->getView('ventas', "formato_fcam", $data);
//        }
        
        $html = $this->views->getView('ventas', "copia_factura", $data);        

        echo $html;
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf();
        if ($data['venta']['estado'] == 0) {
            $mpdf->SetWatermarkImage('Assets/img/anulado.png');
            $mpdf->showWatermarkImage = true;
        }

        $mpdf = new \Mpdf\Mpdf([
            'format' => 'Letter',
            'orientation' => 'P',
            'margin_left' => 3,
            'margin_right' => 3,
            'margin_top' => 3,
            'margin_bottom' => 3
        ]);

       
        $mpdf->WriteHTML($html);
        $mpdf->Output('Factura-'.$data['venta']['numfel'].'.pdf',"I");
    }
    */


    //IMPRESION EN FORMATO TICKET
    /*
    public function ticket($folio)
    {
        $data['estilo'] = 'ticket.css';
        $data['logo_tamanio'] = 50;
        $data['empresa'] = $this->model->getEmpresa();
        $data['venta'] = $this->model->getVenta($folio);
        $data['detalle'] = $this->model->detalleVentas($folio);
        ob_start();
        $html = $this->views->getView('ventas', "reporte", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';

        $mpdf = new \Mpdf\Mpdf([
            'mode' => 'utf-8',
            'format' => [48, 210],
            'margin_left' => 2,
            'margin_right' => 2,
            'margin_top' => 0,
            'margin_bottom' => 0
        ]);

        if ($data['venta']['estado'] == 0) {
            $mpdf->SetWatermarkImage('Assets/img/anulado.png');
            $mpdf->showWatermarkImage = true;
        }
        $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
        $mpdf->WriteHTML($html);
        $mpdf->Output();
    }
    */

}

function basico($numero) {
    $valor = array ('uno','dos','tres','cuatro','cinco','seis','siete','ocho',
    'nueve','diez','once','doce','trece','catorce','quince','dieciseis','diecisiete','dieciocho','diecinueve','veinte','veintiuno ','vientidos ','VEINTITRÉS ', 'veinticuatro','veinticinco',
    'VEINTISÉIS','veintisiete','veintiocho','veintinueve');
    return $valor[$numero - 1];
    }
    
    function decenas($n) {
    $decenas = array (30=>'treinta',40=>'cuarenta',50=>'cincuenta',60=>'sesenta',
    70=>'setenta',80=>'ochenta',90=>'noventa');
    if( $n <= 29) return basico($n);
    $x = $n % 10;
    if ( $x == 0 ) {
    return $decenas[$n];
    } else return $decenas[$n - $x].' y '. basico($x);
    }
    
    function centenas($n) {
    $cientos = array (100 =>'cien',200 =>'doscientos',300=>'trecientos',
    400=>'cuatrocientos', 500=>'quinientos',600=>'seiscientos',
    700=>'setecientos',800=>'ochocientos', 900 =>'novecientos');
    if( $n >= 100) {
    if ( $n % 100 == 0 ) {
    return $cientos[$n];
    } else {
    $u = (int) substr($n,0,1);
    $d = (int) substr($n,1,2);
    return (($u == 1)?'ciento':$cientos[$u*100]).' '.decenas($d);
    }
    } else return decenas($n);
    }
    
    function miles($n) {
    if($n > 999) {
    if( $n == 1000) {return 'mil';}
    else {
    $l = strlen($n);
    $c = (int)substr($n,0,$l-3);
    $x = (int)substr($n,-3);
    if($c == 1) {$cadena = 'MIL '.centenas($x);}
    else if($x != 0) {$cadena = centenas($c).' MIL '.centenas($x);}
    else $cadena = centenas($c). ' MIL';
    return $cadena;
    }
    } else return centenas($n);
    }
    
    function millones($n) {
    if($n == 1000000) {return 'UN MILLÓN';}
    else {
    $l = strlen($n);
    $c = (int)substr($n,0,$l-6);
    $x = (int)substr($n,-6);
    if($c == 1) {
    $cadena = ' MILLÓN ';
    } else {
    $cadena = ' MILLONES ';
    }
    return miles($c).$cadena.(($x > 0)?miles($x):'');
    }
    }
    function convertir($n) {
    switch (true) {
    case ( $n >= 1 && $n <= 29) : return basico($n); break;
    case ( $n >= 30 && $n < 100) : return decenas($n); break;
    case ( $n >= 100 && $n < 1000) : return centenas($n); break;
    case ($n >= 1000 && $n <= 999999): return miles($n); break;
    case ($n >= 1000000): return millones($n);
    }
    }

function dateToSpanish($dateStr, $includeTime = false) {
    try {
        $date = new DateTime($dateStr);
        
        // Usar IntlDateFormatter para español moderno
        if (class_exists('IntlDateFormatter')) {
            $locale = 'es_ES';
            if ($includeTime) {
                // Formato: "15 de octubre de 2023 a las 14:30"
                $formatter = new IntlDateFormatter(
                    $locale,
                    IntlDateFormatter::LONG,
                    IntlDateFormatter::SHORT,
                    'America/Guatemala',
                    IntlDateFormatter::GREGORIAN,
                    "d/MM/y HH:mm"
                );
            } else {
                // Formato: "15 de octubre de 2023"
                $formatter = new IntlDateFormatter(
                    $locale,
                    IntlDateFormatter::LONG,
                    IntlDateFormatter::NONE,
                    'America/Guatemala',
                    IntlDateFormatter::GREGORIAN,
                    "d/MM/y"
                );
            }
            return $formatter->format($date);
        }
        
        // Fallback si no está disponible IntlDateFormatter
        $months = [
            'January' => 'enero', 'February' => 'febrero', 'March' => 'marzo',
            'April' => 'abril', 'May' => 'mayo', 'June' => 'junio',
            'July' => 'julio', 'August' => 'agosto', 'September' => 'septiembre',
            'October' => 'octubre', 'November' => 'noviembre', 'December' => 'diciembre'
        ];
        
        $day = $date->format('j');
        $month = $months[$date->format('F')];
        $year = $date->format('Y');
        
        if ($includeTime) {
            $time = $date->format('H:i');
            return "$day de $month de $year a las $time";
        } else {
            return "$day de $month de $year";
        }
        
    } catch (Exception $e) {
        return $dateStr;
    }
}