<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte</title>
    <link rel="stylesheet" href="<?php echo base_url . 'Assets/css/reporte.css'; ?>">
</head>

<body>
    <table id="datos-empresa">
        <tr>
            <td class="logo">
                <img src="<?php echo base_url . 'Assets/img/logo.png'; ?>" alt="" width="150">
            </td>
            <td class="info-empresa">
                <p><b><?php echo $data['empresa']['nombre']; ?></b></p>
                <hr>
                <p><b>Ruc:</b> <?php echo $data['empresa']['identidad']; ?></p>
                <p><b>Teléfono:</b> <?php echo $data['empresa']['telefono']; ?></p>
                <p><b>Dirección:</b> <?php echo $data['empresa']['direccion']; ?></p>
            </td>
            <td class="info-detalle">
                <p>Caja: <strong><?php echo $data['caja']['caja']; ?></strong></p>
                <p>Fecha: <?php echo date('d/m/Y'); ?></p>
                <p>Hora: <?php echo date('H:i:s'); ?></p>
            </td>
        </tr>
    </table>

    <h5 class="title">Detalle de caja</h5>
    <table id="container-producto">
        <thead>
            <tr>
                <th class="text-center">M. Inicial</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="text-center"><?php echo number_format($data['datos'], 2); ?></td>
            </tr>
        </tbody>
    </table>
    <table id="container-producto">
        <thead>
            <tr>
                <th class="text-left">Gasto</th>
                <th class="text-left">Ingresos</th>
                <th class="text-left">Egresos</th>
                <th class="text-left">Prestamo</th>
                <th class="text-left">Devolucion</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?php echo number_format($data['gasto'], 2); ?></td>
                <td><?php echo number_format($data['monto'], 2); ?></td>
                <td><?php echo number_format($data['egresos'], 2); ?></td>
                <td><?php echo number_format($data['prestamo'], 2); ?></td>
                <td><?php echo number_format($data['devolucion'], 2); ?></td>
            </tr>
        </tbody>
    </table>
    <table id="container-producto">
        <thead>
            <tr>
                <th class="text-center">Saldo</th>
                <th class="text-center">Saldo + Monto inicial</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="text-center"><?php echo number_format($data['saldo'], 2); ?></td>
                <td class="text-center"><?php echo number_format($data['saldo'] + $data['datos'], 2); ?></td>
            </tr>
        </tbody>
    </table>
    <div class="mensaje">
        <?php echo $data['empresa']['mensaje']; ?>
    </div>

</body>

</html>