<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Iniciar Sesión</title>

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- icheck bootstrap -->
    <link rel="stylesheet" href="<?php echo base_url; ?>Assets/css/icheck-bootstrap.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo base_url; ?>Assets/css/adminlte.min.css">
    

<style>

.bg-login {
    background-image:url('<?php echo base_url; ?>Assets/img/login.webp');
    background-repeat: no-repeat;
    min-height: 100vh;
    background-size: cover;

    background-position: top center;    
}
DIV.login-box,DIV.login-box .card, DIV.login-box .card-header {
    background-color:transparent !important;
    outline: none !important;
    border:0px none !important;
    box-shadow: none;
}
INPUT.input-login {
    background:#00bbff;
    border-color: #00bbff;
    border-top-right-radius: 25px;
    border-bottom-right-radius: 25px;
}
INPUT.input-login:active, INPUT.input-login:focus {
    color:#001b8f;
    background:#00bbff;
    border-color: #00bbff;
}

INPUT.input-login::placeholder {
    color:rgba(0,27,143,0.5);
}

INPUT.input-login::-ms-input-placeholder {
/*    color:rgba(0,27,143,1);
    color:#f00 !important;*/
}

DIV.icon-login {
    border-color: #00bbff;
    color:#00bbff;
    background-color: #001b8f;
}
DIV.icon-login SPAN {
    color:#00bbff;
}
</style>

</head>

<body class="hold-transition login-page bg-login">
    <div class="login-box">
        <!-- /.login-logo -->
        <div class="card card-outline">
            <div class="card-header text-center">
                <a href="#" class="h4 text-dark"><b><?php echo isset($data['nombre']) ? $data['nombre'] : 'POS'; ?></b></a>
            </div>
            <div class="card-body">
                <form id="formulario" class="needs-validation" novalidate autocomplete="off">
                    <div class="col-12">
                        <div class="input-group mb-3">
                            <div class="input-group-append ">
                                <div class="input-group-text border-0 icon-login">
                                    <span class="fas fa-user"></span>
                                </div>
                            </div>
                            <input type="text" class="form-control input-login" placeholder="Usuario" name="usuario" id="usuario" required>
                        </div>
                        <div class="valid-feedback">
                            Correcto
                        </div>
                        <div class="invalid-feedback">
                            El usuario es requerido
                        </div>
                    </div>
                    <div class="col-12 text-center">
                        <div class="input-group mb-3">
                            <div class="input-group-append">
                                <div class="input-group-text border-0 icon-login">
                                    <span class="fas fa-lock"></span>
                                </div>
                            </div>
                            <input type="password" class="form-control input-login" placeholder="Contraseña" name="clave" id="clave" required>                            
                        </div>
                        <div class="valid-feedback">
                            Correcto
                        </div>
                        <div class="invalid-feedback">
                            La contraseña es requerido
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary btn-block" id="btnAccion" style='margin:auto;border:0px none;background:#001b8f;width:150px;'>Login</button>
                </form>

                <p class="mt-2 text-center">
                    <a href="<?php echo base_url; ?>usuarios/recuperar" class='text-dark'>Olvidaste tu contraseña</a>
                </p>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
    <!-- /.login-box -->

    <!-- jQuery -->
    <script src="<?php echo base_url; ?>Assets/js/jquery-3.6.0.min.js"></script>
    <!-- Bootstrap 4 -->
    <script src="<?php echo base_url; ?>Assets/js/bootstrap.bundle.min.js"></script>
    <!-- AdminLTE App -->
    <script src="<?php echo base_url; ?>Assets/js/adminlte.min.js"></script>
    <script src="<?php echo base_url; ?>Assets/js/sweetalert2.all.min.js"></script>
    <script src="<?php echo base_url; ?>Assets/js/all.min.js"></script>
    <script>
        const base_url = '<?php echo base_url; ?>';
    </script>
    <script src="<?php echo base_url; ?>Assets/js/login.js"></script>
</body>

</html>