<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte</title>
    <link rel="stylesheet" href="<?php echo base_url . 'Assets/css/reporte.css'; ?>">
</head>

<body>
    <table id="datos-empresa">
        <tr>
            <td class="logo">
                <img src="<?php echo base_url . 'Assets/img/logo.png'; ?>" alt="" width="150">
            </td>
            <td class="info-empresa">
                <p><b><?php echo $data['empresa']['nombre']; ?></b></p>
                <hr>
                <p><b>Ruc:</b> <?php echo $data['empresa']['identidad']; ?></p>
                <p><b>Teléfono:</b> <?php echo $data['empresa']['telefono']; ?></p>
                <p><b>Dirección:</b> <?php echo $data['empresa']['direccion']; ?></p>
            </td>
            <td class="info-detalle">
                <p>Fecha: <?php echo date('d/m/Y'); ?></p>
                <p>Hora: <?php echo date('H:i:s'); ?></p>
            </td>
        </tr>
    </table>

    <h5 class="title">Productos</h5>
    <table id="container-producto">
        <thead>
            <tr>
                <th class="text-left">Código</th>
                <th class="text-left">Cant</th>
                <th class="text-left">Descripción</th>
                <th class="text-right">P.compra</th>
                <th class="text-right">P.venta</th>
                <th class="text-right">Medida</th>
                <th class="text-right">Marca</th>
                <th class="text-right">Categoria</th>
            </tr>
        </thead>
        <tbody>
            <?php
            foreach ($data['productos'] as $producto) { ?>
                <tr>
                    <td><?php echo $producto['codigo']; ?></td>
                    <td><?php echo $producto['cantidad']; ?></td>
                    <td><?php echo $producto['descripcion']; ?></td>
                    <td class="text-right"><?php echo number_format($producto['precio_compra'], 2); ?></td>
                    <td class="text-right"><?php echo number_format($producto['precio_venta'], 2); ?></td>
                    <td><?php echo $producto['medida']; ?></td>
                    <td><?php echo $producto['marca']; ?></td>
                    <td><?php echo $producto['categoria']; ?></td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
    <div class="mensaje">
        <?php echo $data['empresa']['mensaje']; ?>
    </div>

</body>

</html>