let t_cli;
const form = document.getElementById('formulario');
const id_cliente = document.getElementById('id');
const title = document.getElementById('title');
const btnAccion = document.getElementById('btnAccion');

// Reconocimiento de voz
const botonInicio = document.getElementById('botonInicioREC');
const salida = document.getElementById('salida');

const botonInicioVisita = document.getElementById('botonInicioRECVisita');
const salidaVisita = document.getElementById('salidaVisita');

const botonInicioRECVisita = document.getElementById('botonInicioRECVisita');


const coordenadas_cliente = document.getElementById('coordenadas_cliente');
const coordenadas_ultima_visita_entrada = document.getElementById('coordenadas_ultima_visita_entrada');
const coordenadas_ultima_visita_salida = document.getElementById('coordenadas_ultima_visita_salida');
const observaciones_visita = document.getElementById('observaciones_visita');



botonInicio.addEventListener('click', function() {
    var speech = true;
    window.SpeechRecognition = window.webkitSpeechRecognition || window.SpeechRecognition;

    const reconocimiento = new SpeechRecognition();
    reconocimiento.interimResults = true;

    reconocimiento.addEventListener('result', e => {
        const transcripcion = Array.from(e.results)
            .map(resultado => resultado[0])
            .map(resultado => resultado.transcript)
            .join('');

        salida.innerHTML = transcripcion;

        // console.log(transcripcion);
    });

    // Iniciar el reconocimiento de voz si la variable 'speech' es true.
    if (speech === true) {
        reconocimiento.start();
    }
});


botonInicioRECVisita.addEventListener('click', function() {

    botonInicioRECVisita.disabled = true;
    //const botonInit=setTimeout(() => { botonInicioRECVisita.disabled = true; }, 10000);

    var speech = true;
    window.SpeechRecognition = window.webkitSpeechRecognition || window.SpeechRecognition;

    const reconocimiento = new SpeechRecognition();
    reconocimiento.interimResults = true;

    reconocimiento.addEventListener('end', e => {
        //clearTimeout(botonInit);
        botonInicioRECVisita.disabled = false;
    });

    reconocimiento.addEventListener('result', e => {
        /*const transcripcion = Array.from(e.results)
            .map(resultado => resultado[0])
            .map(resultado => resultado)
            .join(''); //.transcript*/
        if(e.results[0].isFinal=== true) {
            salidaVisita.innerHTML += e.results[0][0].transcript.toLowerCase()+' ';
        }
    });

    if (speech === true) {
        reconocimiento.start();
    }
});



// CAMPOS DE BUSQUEDA
const vendedor = document.getElementById('vendedor');
const ruta = document.getElementById('ruta');
const filtro_fecha = document.getElementById('filtro_fecha');
const fecha_desde = document.getElementById('fecha_desde');
const fecha_hasta = document.getElementById('fecha_hasta');

let   advanced_search_bool = false;
const advanced_search = document.getElementById('advanced_search');

// FIN CAMPOS DE BUSQUEDA

const nombre = document.getElementById('nombre');
const telefono = document.getElementById('telefono');
const mensajeria = document.getElementById('mensajeria');
const tipoid = document.getElementById('tipoid');
const nit = document.getElementById('nit');

const formProgramacion = document.getElementById('formularioProgramacion');
const idProgramacion = document.getElementById('id_programacion');
const rowProgramacion = document.getElementById('row_programacion');
const fechaProgramacion = document.getElementById('fecha_programacion');
const codigoClienteProgramacion = document.getElementById('codigo_cliente_programacion');
const nombreClienteProgramacion = document.getElementById('nombre_cliente_programacion');
const vendedorClienteProgramacion = document.getElementById('vendedor_cliente_programacion');


const formCobro = document.getElementById('formularioCobro');
const idCobro = document.getElementById('id_cobro');
const rowCobro = document.getElementById('row_cobro');
const fechaCobro = document.getElementById('fecha_cobro');
const codigoClienteCobro = document.getElementById('codigo_cliente_cobro');
const nombreClienteCobro = document.getElementById('nombre_cliente_cobro');
const vendedorClienteCobro = document.getElementById('vendedor_cliente_cobro');


const formLlamada = document.getElementById('formularioLlamada');
const idLlamada = document.getElementById('id_llamada');
const rowLlamada = document.getElementById('row_llamada');
const fechaLlamada = document.getElementById('fecha_llamada');
const codigoClienteLlamada = document.getElementById('codigo_cliente_llamada');
const nombreClienteLlamada = document.getElementById('nombre_cliente_llamada');
const vendedorClienteLlamada = document.getElementById('vendedor_cliente_llamada');


const direccion = document.getElementById('direccion');
const municipio = document.getElementById('municipio');
const departamento = document.getElementById('departamento');
const pais = document.getElementById('pais');
const coordenadas = document.getElementById('coordenadas');
const coord_ultimavisita = document.getElementById('coord_ultimavisita');

const contacto = document.getElementById('contacto');
const telcontacto = document.getElementById('telcontacto');
const observaciones = document.getElementById('observaciones');

const limite_credito = document.getElementById('limite_credito');
const dias_credito = document.getElementById('dias_credito');
const id_vendedor1 = document.getElementById('id_vendedor1');
const tipocliente = document.getElementById('tipocliente');

const formAnotaciones = document.getElementById('formularioAnotaciones');
const formAnotacionesVisita = document.getElementById('formularioAnotacionesVisita');

const id_cliente_anotaciones = document.getElementById('id_cliente_anotaciones');
const id_cliente_anotacionesVisita = document.getElementById('id_cliente_anotacionesVisita');

const observaciones_anotaciones = document.getElementById('observaciones_anotaciones');
const nombre_reporte_modal = document.getElementById('nombre_reporte_modal');
const year_pagos = document.getElementById('yearPagos');
const year_ventas = document.getElementById('yearVentas');

const reporte_ventas_table = document.getElementById('reporteventastable');
const reporte_pagos_table = document.getElementById('reportepagostable');

const minEl = document.querySelector('#min');
const maxEl = document.querySelector('#max');

const optionsDate = { year: 'numeric', month: 'short' , day: 'numeric', timeZone: 'UTC' };
const optionsDateTime = { year: 'numeric', month: 'short' , day: 'numeric', hour: '2-digit', minute: '2-digit', second: '2-digit', timeZone: 'UTC'};

let ventasChartObj=false;
let ventasChartCanvas=false;
let pagosChartObj=false;
let pagosChartCanvas=false;

let active_row=false;
let active_obj=false;
let active_meta=false;

let option=null;
var windowWidth = $(window).width();

var fecha_prog = $('#fecha_programacion_box').datepicker().on('changeDate', function(ev) { 
    fecha_prog.hide();
  }).data('datepicker');

document.addEventListener('DOMContentLoaded', function(){

    //DataTables Clientes - Ajax
    t_cli = $('#t_cli').DataTable({
        "aPreocesing": true,
        "aServerSide": false,
        "ajax": {
            "url": "" + base_url + "clientes/listar",
            "dataSrc": ""
        },
        "deferRender": true,
        "drawCallback": function( settings ) {
                //btnAnotacionesCliVisita(34,23)
        },     
        "columns": [
            {"data": "ultimaventa_search","visible": false },        
            {"data": "ultimopago_search","visible": false },
            {"data": "programacion_search","visible": false },
            {"data": "ultimavisita_search","visible": false },

            // {"data": "codigo"},

            {
                "data": "codigo",
                "render": function ( data, type, row, meta ) {
                    
                    if (windowWidth <=650) {
                        return `<small style='max-width:200px;display:block;line-height:1em;'>[${data}]<br/>${row['nombre']}</small>`;
                    } else {
                        return `${data}`;
                    }
                    
                },
            },            

            {"data": "nombre"},
            {
                "data": "estado",
                "render": function ( data, type, row, meta ) {
                    if(row['estado'] == 1){
                        return `<span class="badge badge-success">Activo</span>`;
                    } else {
                        return `<span class="badge badge-danger">Inactivo</span>`;
                    }
                },                
            },
            {
                "data": "id_vendedor1",
                "render": function ( data, type, row, meta ) {

                    if (data in vendedores_nombres) {
                        return `<a title='${vendedores_nombres[data]}' style='cursor:pointer;'>${data}</a>`
                    } else {
                        return `<a title='Vendedor no encontrado' style='cursor:pointer;'>${data}</a>`
                    }
                },
            },
            {"data": "ruta"},            
            {"data": "saldo",
                "render": function ( data, type, row, meta ) {
                    //console.log(row['diasdiferencia'],data)
                    let  varsaldo = data;
                    if(row['saldo']<=row['limite_credito']){
                        return `<p class='text text-right text-success font-weight-bold'>${varsaldo}</p>`;
                    } else {
                        return `<p class='text text-right text-danger font-weight-bold'>${varsaldo}</p>`;
                    }
                },
            },
            {
                "data": "ultimaventa",
                "render": function ( data, type, row, meta ) {
                    
                    arr=row['ultimaventa'];
                    //arr=new Intl.DateTimeFormat('es-GT', optionsDate).format(new Date(data));
                    if(row['diasdiferencia']<=30){
                        return `<span class='badge badge-success'>${arr}</span>`;
                    } else if(row['diasdiferencia']<=60) {
                        return `<span class='badge badge-warning'>${arr}</span>`;
                    } else if(row['diasdiferencia']>60) {
                        return `<span class='badge badge-danger'>${arr}</span>`;
                    }
                },
            },
            {
                "data": "ultimopago",
                "render": function ( data, type, row, meta ) {
                    
                    arr=data;
                    //arr=new Intl.DateTimeFormat('es-GT', optionsDate).format(new Date(data));
                    if(row['diasdiferenciapago']<=30){
                        return `<span class='badge badge-success'>${arr}</span>`;
                    } else if(row['diasdiferenciapago']<=60) {
                        return `<span class='badge badge-warning'>${arr}</span>`;
                    } else if(row['diasdiferenciapago']>60) {
                        return `<span class='badge badge-danger'>${arr}</span>`;
                    }
                },
            },            
            {
                "data": "programacion",
                "render": function ( data, type, row, meta ) {
                    //arr=new Intl.DateTimeFormat('es-GT', optionsDate).format(new Date(data));
                    //arr=new Intl.DateTimeFormat('es-GT', optionsDate).format(new Date(data));
                    arr=data;

                    if(row['diasdiferenciaprogramacion']<=30){
                        return `<span class="badge badge-success">${arr}</span>
                                <button class="btn btn-success" type="button" onclick="btnProgramarCli(${row['id']},${meta.row});"><i class="far fa-calendar-alt"></i></button>`;
                    } else if(row['diasdiferenciaprogramacion']<=60) {
                        return `<span class="badge badge-warning">${arr}</span>
                                <button class="btn btn-warning" type="button" onclick="btnProgramarCli(${row['id']},${meta.row});"><i class="far fa-calendar-alt"></i></button>`;
                    } else if(row['diasdiferenciaprogramacion']>60) {
                        return `<span class="badge badge-danger">${arr}</span>
                                <button class="btn btn-danger" type="button" onclick="btnProgramarCli(${row['id']},${meta.row});"><i class="far fa-calendar-alt"></i></button>`;
                    }

                },
            },        
            {"data": "ultimavisita",
                "render": function ( data, type, row, meta ) {

                    arr=data;
                    if(row['diasdiferenciavisita']<=30){
                        return `
                        <button class="btn btn-link" type="button" onclick="btnVervisitaCli(${row['id']});"><i class="fas fa-map-marker-alt"></i></button>
                        <span class="badge badge-success">${arr}</span>
                        <button class="btn btn-success" type="button" onclick="btnVisitarCli(${row['id']},${meta.row});"><i class="fas fa-map-marker-alt"></i></button>
                        <button class="btn btn-danger" type="button" onclick="btnAnotacionesCliVisita(${row['id']},${meta.row});"><i class="fas fa-map-marker"></i></button>                        
                        `;

                    } else if(row['diasdiferenciavisita']<=60) {
                        return `
                        <button class="btn btn-link" type="button" onclick="btnVervisitaCli(${row['id']});"><i class="fas fa-map-marker-alt"></i></button>
                        <span class="badge badge-warning">${arr}</span>
                        <button class="btn btn-success" type="button" onclick="btnVisitarCli(${row['id']},${meta.row});"><i class="fas fa-map-marker-alt"></i></button>
                        <button class="btn btn-danger" type="button" onclick="btnAnotacionesCliVisita(${row['id']},${meta.row});"><i class="fas fa-map-marker"></i></button>                        
                        `;

                    } else if(row['diasdiferenciavisita']>60) {
                        return `
                        <button class="btn btn-link" type="button" onclick="btnVervisitaCli(${row['id']});"><i class="fas fa-map-marker-alt"></i></button>
                        <span class="badge badge-danger">${arr}</span>
                        <button class="btn btn-success" type="button" onclick="btnVisitarCli(${row['id']},${meta.row});"><i class="fas fa-map-marker-alt"></i></button>
                        <button class="btn btn-danger" type="button" onclick="btnAnotacionesCliVisita(${row['id']},${meta.row});"><i class="fas fa-map-marker"></i></button>                        
                        `;
                    }

                },
            },            
            {"data": "direccion"},
            {"data": "departamento"},            
            {"data": "telefono"},
            {"data": "descuento"},            
            {"data": "dias_credito"},                                    
            {"data": "limite_credito"},                        
        ],

        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [0, "desc"]
        ]

    });

    
    $('#filter-input').keyup(function(){
        /*table.column($(this).data('column'))
        .search($(this).val())
        .draw();*/
        search_cliente();
    });

    t_cli.on( 'draw', function () {
        $('#t_cli tbody tr').removeClass('selected');
        activo_buttons(false)
        //frmCliente()
        //btnEditarCli(15)
    } );

    $('#t_cli tbody').on( 'click', 'tr', function (e) {
        let classList = e.currentTarget.classList;
       
        if (classList.contains('selected')) {
            classList.remove('selected');
            active_meta=false;
        }
        else {
            t_cli.rows('.selected').nodes().each((row) => row.classList.remove('selected'));
            classList.add('selected');
            active_meta=t_cli.row( this ).index();
        }
        
        activo_buttons( t_cli.row( this ).data()  );
    } );

    function activo_buttons(obj)
    {
        //if(obj === undefined) { return }
        active_obj=obj;
        if(obj !== undefined) active_row=active_obj.id;

        if($('#t_cli tbody tr.selected').length==0)
        {
            active_row=false;
            $('BUTTON.btn-toolbar-status').attr('disabled', 'disabled');
            $('BUTTON.btn-recuperar').hide();
            $('BUTTON.btn-eliminar').show();            
        } else {
            $('BUTTON.btn-toolbar-status').removeAttr('disabled');
            
            if(active_obj !== undefined)
            {
                if(active_obj.estado_txt==='activo') {
                    $('BUTTON.btn-recuperar').hide();
                    $('BUTTON.btn-eliminar').show();
                } else {
                    $('BUTTON.btn-recuperar').show();
                    $('BUTTON.btn-eliminar').hide();
                }
            } else {

            }
         
        }
    }

    var forms = document.getElementsByClassName('needs-validation');
    // Loop over them and prevent submission
    var validation = Array.prototype.filter.call(forms, function (form) {
        form.addEventListener('submit', function (event) {
            event.preventDefault();

            if (form.checkValidity() === false) {
                event.stopPropagation();
                form.classList.add('was-validated');
                $('#nuevo_cliente li a#'+$('FORM.needs-validation INPUT:invalid').first().parents('DIV.tab-pane').prop('id')+'-tab').tab('show')
            } else {
                const url = base_url + 'clientes/registrar';
                const http = new XMLHttpRequest();
                http.open("POST", url, true);
                http.send(new FormData(this));
                http.onreadystatechange = function () {
                    if (this.readyState == 4 && this.status == 200) {
                        const res = JSON.parse(this.responseText);
                        alertas(res.msg, res.icono);
                        if (res.icono == 'success') {
                            $('#nuevo_cliente').modal('hide');
                            t_cli.ajax.reload();
                        }
                    }
                }
            }

        }, false);
    });

    formAnotaciones.addEventListener('submit', function (event) {
        event.preventDefault();

        const url = base_url + 'clientes/editarAnotaciones';
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(this));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const res = JSON.parse(this.responseText);
                
                alertas(res.msg, res.icono);
                if (res.icono == 'success') {
                    $('#modal_anotaciones').modal('hide');
                    //t_cli.ajax.reload();
                }
            }
        }

    }, false);

    formAnotacionesVisita.addEventListener('submit', function (event) {
        event.preventDefault();
        const formData = new FormData(this);

        if (navigator.geolocation) {
            var options = {enableHighAccuracy: true,timeout: 5000,maximumAge: 0};
            if (typeof(idgeo) !== 'undefined') navigator.geolocation.clearWatch(idgeo)
            idgeo=navigator.geolocation.getCurrentPosition(function(position) { 

                Mycoords=position.coords.accuracy+"|"+position.coords.latitude+"|"+position.coords.longitude;
                formData.append('coordenadas', Mycoords);

                const url = base_url + 'clientes/editarAnotacionesVisitas';
                const http = new XMLHttpRequest();
                http.open("POST", url, true);
                http.send(formData);
                http.onreadystatechange = function () {
                    if (this.readyState == 4 && this.status == 200) {
                        const res = JSON.parse(this.responseText);

                        alertas(res.msg, res.icono);
                        if (res.icono == 'success') {
                            $('#modal_anotacionesVisita').modal('hide');
                            t_cli.ajax.reload();
                        }
                    }
                }
            }, error,options);
        } else {
        error('not supported');
        }



    }, false);


    formProgramacion.addEventListener('submit', function (event) {
        event.preventDefault();

        const url = base_url + 'clientes/editarProgramacion';
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(this));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const res = JSON.parse(this.responseText);
                alertas(res.msg, res.icono);
                if (res.icono == 'success') {
                    const drow = t_cli.row( rowProgramacion.value );
                    const rowData = drow.data();
                    rowData.programacion=fechaProgramacion.value
                    rowData.diasdiferenciaprogramacion=calculateDateDifferenceInDays(new Date(fechaProgramacion.value), new Date());

                    rowData.programacion_format=new Intl.DateTimeFormat('es-GT', optionsDate).format(new Date(fechaProgramacion.value));
                    
                    drow.data(rowData).draw();

                    $('#modal_programacion').modal('hide');
                }
            }
        }

    }, false);

    formCobro.addEventListener('submit', function (event) {
        event.preventDefault();

        const url = base_url + 'clientes/editarCobro';
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(this));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const res = JSON.parse(this.responseText);
                alertas(res.msg, res.icono);
                if (res.icono == 'success') {

                    const drow = t_cli.row( rowCobro.value );
                    const rowData = drow.data();
                    rowData.cobro=fechaCobro.value
                    drow.data(rowData).draw();

                    $('#modal_cobro').modal('hide');
                }
            }
        }

    }, false);

    formLlamada.addEventListener('submit', function (event) {
        event.preventDefault();

        const url = base_url + 'clientes/editarLlamada';
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(this));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const res = JSON.parse(this.responseText);
                alertas(res.msg, res.icono);
                if (res.icono == 'success') {

                    const drow = t_cli.row( rowLlamada.value );
                    const rowData = drow.data();
                    rowData.llamada=fechaLlamada.value
                    drow.data(rowData).draw();

                    $('#modal_llamada').modal('hide');
                }
            }
        }

    }, false);

    console.clear();

    if ('SpeechRecognition' in window || 'webkitSpeechRecognition' in window) 
    {
        botonInicioRECVisita.disabled=false;
    } else {
        botonInicioRECVisita.disabled=true;
    }


})

let resizeTimeout;

window.onresize = function () {

    clearTimeout(resizeTimeout);

    // Acción a realizar al cambiar el tamaño de la ventana
    //console.log("La ventana ha cambiado de tamaño.");

    // Ejemplo: Ajustar el ancho de una tabla
    /*if (t_cli) {
        t_cli.columns.adjust().draw(); // Ajustar columnas de DataTables
    }*/
    resizeTimeout = setTimeout(function () {
        if (t_cli) {
            windowWidth = $(window).width();            
            console.log(`La ventana ha cambiado de tamaño. ${windowWidth}`);        
            t_cli.rows().invalidate().draw();
            //t_cli.columns.adjust().draw();
            //t_cli.draw();
        }
    }, 1000);
};


function frmCliente() {
    id_cliente.value = '';
    title.textContent = 'Nuevo Cliente';
    btnAccion.textContent = 'Registrar';
    form.classList.remove('was-validated');    
    form.reset();

    const url = base_url + 'clientes/insertar';
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();

    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            
            pais.innerHTML = "";
            option = document.createElement("option");
            option.text = "Seleccione país";
            option.value = '';
            pais.add(option);

            res.paises.forEach(function(element) {
                option = document.createElement("option");
                option.text = element['pais'];
                option.value = element['cod'];
                pais.add(option);
            });            

            id_vendedor1.innerHTML = "";
            option = document.createElement("option");
            option.text = "Seleccione vendedor";
            option.value = '';
            id_vendedor1.add(option);

            res.vendedores.forEach(function(element) {
                option = document.createElement("option");
                option.text = element['nombre'];
                option.value = element['codven'];
                id_vendedor1.add(option);
            }); 

            pais.value = 'GT';
            id_vendedor1.value = '';

            $('#nuevo_cliente').modal('show');
            $('#nuevo_cliente li a#generales-tab').tab('show')
        }
    }


}

let newtab;

function btnWhatsappCli(id)
{
    if(id===false) return;

    let mensajeria=t_cli.rows('.selected').data();
    const filteredStr = mensajeria[0].mensajeria.replace(/\D/g, '');
    if(filteredStr.length==8)
    {
        newTab = window.open('https://api.whatsapp.com/send?phone=502'+filteredStr, "myNewWindow", "width=500,height=500");
        setTimeout(() => { 
            newTab.window.close();
        }, 1000);
    } else {
        alertas('No tiene definido un número de mensajería válido', 'danger');
    }
   
}

function btnReporteEstadoCuenta(id)
{
    window.open(base_url +'clientes/generarReporteEstadoCuenta/'+id, "_blank");
}

function btnReporteAntiguedadSaldos(id)
{
    if(id===false) id=0
    window.open(base_url +'clientes/generarReporteAntiguedadSaldos/'+id, "_blank");
}

function btnReporteCuentasxCobrar(id)
{
    if(id===false) id=0
    window.open(base_url +'clientes/generarReporteCuentasCobrar/'+id, "_blank");
}

function btnReporteCli(id)
{
    if(id===false) return
    window.open(base_url +'clientes/dashboard/'+id, "_blank");

    /*const url = base_url + 'clientes/editar/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            nombre_reporte_modal.innerHTML=res.nombre;
            id_cliente.value = res.id;

            $('#reporte_cliente').modal('show');
            actualizarGraficoVentasMesCliente();
            actualizarGraficoPagosMesCliente();

        }
    }*/
}

function actualizarGraficoPagosMesCliente() {
    const anio = year_pagos.value;
    const idcliente = id_cliente.value;
    
    if(pagosChartObj) { pagosChartObj.destroy(); }

    pagosChartCanvas = $('#comparacionPagos').get(0).getContext('2d') 
    const url = base_url + 'clientes/comparacionPagosMes/' + anio +'/'+ idcliente;    

    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);

            var salesChartData = {
                labels: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
                datasets: [
                  {
                    label: 'Pagos',
                    backgroundColor: 'rgba(247,222,97,0.9)',
                    borderColor: 'rgba(247,222,97,0.8)',
                    pointRadius: false,
                    pointColor: '#3b8bba',
                    pointStrokeColor: 'rgba(247,222,97,1)',
                    pointHighlightFill: '#fff',
                    pointHighlightStroke: 'rgba(247,222,97,1)',
                    data: [res.pagos.ene, res.pagos.feb, res.pagos.mar, res.pagos.abr, res.pagos.may, res.pagos.jun, res.pagos.jul, res.pagos.ago, res.pagos.sep, res.pagos.oct, res.pagos.nov, res.pagos.dic],
                  }
                ]
              }
            
              var salesChartOptions = {
                maintainAspectRatio: false,
                responsive: true,
                legend: {
                  display: false
                },
                scales: {
                  xAxes: [{
                    gridLines: {
                      display: false
                    }
                  }],
                  yAxes: [{
                    gridLines: {
                      display: false
                    }
                  }]
                }
              }
            
              // This will get the first returned node in the jQuery collection.
              // eslint-disable-next-line no-unused-vars
              pagosChartObj = new Chart(pagosChartCanvas, {
                type: 'bar',
                data: salesChartData,
                options: salesChartOptions
              }
              )

              let total_anual=sumObj(res.pagos);

              reporte_pagos_table.innerHTML=`
              <tr><th scope="row">Enero</th><td class='text-right'>Q.${numFormat(res.pagos.ene)}</td></tr>
              <tr><th scope="row">Febrero</th><td class='text-right'>Q.${numFormat(res.pagos.feb)}</td></tr>
              <tr><th scope="row">Marzo</th><td class='text-right'>Q.${numFormat(res.pagos.mar)}</td></tr>
              <tr><th scope="row">Abril</th><td class='text-right'>Q.${numFormat(res.pagos.abr)}</td></tr>
              <tr><th scope="row">Mayo</th><td class='text-right'>Q.${numFormat(res.pagos.may)}</td></tr>
              <tr><th scope="row">Junio</th><td class='text-right'>Q.${numFormat(res.pagos.jun)}</td></tr>
              <tr><th scope="row">Julio</th><td class='text-right'>Q.${numFormat(res.pagos.jul)}</td></tr>
              <tr><th scope="row">Agosto</th><td class='text-right'>Q.${numFormat(res.pagos.ago)}</td></tr>
              <tr><th scope="row">Septiembre</th><td class='text-right'>Q.${numFormat(res.pagos.sep)}</td></tr>
              <tr><th scope="row">Octubre</th><td class='text-right'>Q.${numFormat(res.pagos.oct)}</td></tr>
              <tr><th scope="row">Noviembre</th><td class='text-right'>Q.${numFormat(res.pagos.nov)}</td></tr>
              <tr><th scope="row">Diciembre</th><td class='text-right'>Q.${numFormat(res.pagos.dic)}</td></tr>
              <tr><th scope="row" class='text-warning'>TOTAL</th><td class='text-right'>Q.${numFormat(total_anual)}</td></tr>
              `
        }
    }

}

function actualizarGraficoVentasMesCliente() {
    const anio = year_ventas.value;
    const idcliente = id_cliente.value;

    if(ventasChartObj) { ventasChartObj.destroy(); }

    ventasChartCanvas = $('#comparacionVentas').get(0).getContext('2d') 

    const url = base_url + 'clientes/comparacionVentasMes/' + anio +'/'+ idcliente;

    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);

            var salesChartData = {
                labels: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
                datasets: [
                  {
                    label: 'Ventas',
                    backgroundColor: 'rgba(247,222,97,0.9)',
                    borderColor: 'rgba(247,222,97,0.8)',
                    pointRadius: false,
                    pointColor: '#3b8bba',
                    pointStrokeColor: 'rgba(247,222,97,1)',
                    pointHighlightFill: '#fff',
                    pointHighlightStroke: 'rgba(247,222,97,1)',
                    data: [res.ventas.ene, res.ventas.feb, res.ventas.mar, res.ventas.abr, res.ventas.may, res.ventas.jun, res.ventas.jul, res.ventas.ago, res.ventas.sep, res.ventas.oct, res.ventas.nov, res.ventas.dic],
                  }
                ]
              }
            
              var salesChartOptions = {
                maintainAspectRatio: false,
                responsive: true,
                legend: {
                  display: false
                },
                scales: {
                  xAxes: [{
                    gridLines: {
                      display: false
                    }
                  }],
                  yAxes: [{
                    gridLines: {
                      display: false
                    }
                  }]
                }
              }
            
              // This will get the first returned node in the jQuery collection.
              // eslint-disable-next-line no-unused-vars
              ventasChartObj = new Chart(ventasChartCanvas, {
                type: 'bar',
                data: salesChartData,
                options: salesChartOptions
              }
              )

              let total_anual=sumObj(res.ventas);

              reporte_ventas_table.innerHTML=`
              <tr><th scope="row">Enero</th><td class='text-right'>Q.${numFormat(res.ventas.ene)}</td></tr>
              <tr><th scope="row">Febrero</th><td class='text-right'>Q.${numFormat(res.ventas.feb)}</td></tr>
              <tr><th scope="row">Marzo</th><td class='text-right'>Q.${numFormat(res.ventas.mar)}</td></tr>
              <tr><th scope="row">Abril</th><td class='text-right'>Q.${numFormat(res.ventas.abr)}</td></tr>
              <tr><th scope="row">Mayo</th><td class='text-right'>Q.${numFormat(res.ventas.may)}</td></tr>
              <tr><th scope="row">Junio</th><td class='text-right'>Q.${numFormat(res.ventas.jun)}</td></tr>
              <tr><th scope="row">Julio</th><td class='text-right'>Q.${numFormat(res.ventas.jul)}</td></tr>
              <tr><th scope="row">Agosto</th><td class='text-right'>Q.${numFormat(res.ventas.ago)}</td></tr>
              <tr><th scope="row">Septiembre</th><td class='text-right'>Q.${numFormat(res.ventas.sep)}</td></tr>
              <tr><th scope="row">Octubre</th><td class='text-right'>Q.${numFormat(res.ventas.oct)}</td></tr>
              <tr><th scope="row">Noviembre</th><td class='text-right'>Q.${numFormat(res.ventas.nov)}</td></tr>
              <tr><th scope="row">Diciembre</th><td class='text-right'>Q.${numFormat(res.ventas.dic)}</td></tr>
              <tr><th scope="row" class='text-warning'>TOTAL</th><td class='text-right'>Q.${numFormat(total_anual)}</td></tr>
              `
        }
    }

}

//btnReporteCli(47)

function numFormat(num) {
    return new Intl.NumberFormat("gt-GT").format(num)
}

function sumObj(obj) {
    return Object.keys(obj).reduce((acc, key) => acc + parseFloat(obj[key] || 0), 0);
}

function btnEditarCli(id) {
    if(id===false) return
    
    form.classList.remove('was-validated');
    form.reset();
    $('#nuevo_cliente li a#generales-tab').tab('show')
    //$('#nuevo_cliente li a#tdireccion-tab').tab('show')
    //$('#nuevo_cliente li a#parametros-tab').tab('show')
    //$('#nuevo_cliente li a#tcontacto-tab').tab('show') 

    title.textContent = 'Modificar Cliente';
    btnAccion.textContent = 'Modificar';
    const url = base_url + 'clientes/editar/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            
            pais.innerHTML = "";
            option = document.createElement("option");
            option.text = "Seleccione país";
            option.value = '';
            pais.add(option);

            res.paises.forEach(function(element) {
                option = document.createElement("option");
                option.text = element['pais'];
                option.value = element['cod'];
                pais.add(option);
            });            

            id_vendedor1.innerHTML = "";
            option = document.createElement("option");
            option.text = "Seleccione vendedor";
            option.value = '';
            id_vendedor1.add(option);

            res.vendedores.forEach(function(element) {
                option = document.createElement("option");
                option.text = element['nombre'];
                option.value = element['codven'];
                id_vendedor1.add(option);
            }); 

            id_cliente.value = res.id;
            nombre.value = res.nombre;
            telefono.value = res.telefono;
            mensajeria.value = res.mensajeria;
            tipoid.value = res.tipoid;
            nit.value = res.nit;
            direccion.value = res.direccion;
            municipio.value = res.municipio;
            departamento.value = res.departamento;
            pais.value = res.pais;
            coordenadas.value = res.coordenadas;
            
            tipocliente.value = res.tipocliente;

            contacto.value = res.contacto;
            telcontacto.value = res.telcontacto;
            observaciones.value = res.observaciones;

            limite_credito.value = res.limite_credito;
            dias_credito.value = res.dias_credito;
            id_vendedor1.value = res.id_vendedor1;
            

            if(res.estado==0) {
                $('#estado-0').addClass('d-inline-block').removeClass('d-none');
                $('#estado-1').addClass('d-none').removeClass('d-inline-block');
            } else {
                $('#estado-1').addClass('d-inline-block').removeClass('d-none');
                $('#estado-0').addClass('d-none').removeClass('d-inline-block');
            }

            $('#nuevo_cliente').modal('show');
        }
    }
}

function btnAnotacionesCli(id) {
    if(id===false) return
    form.classList.remove('was-validated');
    form.reset();
    $('#modal_anotaciones li a#tcontacto-tab').tab('show')

    const url = base_url + 'clientes/editar/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            
            id_cliente_anotaciones.value = res.id;
            observaciones_anotaciones.value = res.observaciones;

            $('#modal_anotaciones').modal('show');
        }
    }
}


function btnAnotacionesCliVisita(id) {
    salidaVisita.innerHTML = '';
    if(id===false) return
    form.classList.remove('was-validated');
    form.reset();
    $('#modal_anotacionesVisita li a#tcontacto-tab').tab('show')

    const url = base_url + 'clientes/editar/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            
            id_cliente_anotacionesVisita.value = res.id;

            $('#modal_anotacionesVisita').modal('show');
        }
    }
}


function btnEliminarCli(id) {
    if(id===false) return
    Swal.fire({
        title: 'Esta seguro de eliminar?',
        text: "El cliente no se eliminará de forma permanente, solo cambiará el estado a inactivo!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = base_url + "clientes/eliminar/" + id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    alertas(res.msg, res.icono);
                    if (res.icono == 'success') {
                        t_cli.ajax.reload();
                    }
                    
                }
            }
        }
    })
}

function btnReingresarCli(id) {
    Swal.fire({
        title: 'Esta seguro de reingresar?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = base_url + "clientes/reingresar/" + id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    alertas(res.msg, res.icono);
                    if (res.icono == 'success') {
                        t_cli.ajax.reload();
                    }
                }
            }

        }
    })
} //fin clientes


let map
let marker
function btnUbicacionCli(id) {
    if(id===false) return
    form.classList.remove('was-validated');
    form.reset();
    $('#modal_anotaciones li a#tcontacto-tab').tab('show')

    const url = base_url + 'clientes/editar/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            
            id_cliente_anotaciones.value = res.id;
            //

            if(res.coordenadas===null) {
                alertas('No tiene coordenadas definidas', 'danger');
            } else {
                let params = res.coordenadas.split('|');

                let lat=Number( params[1] )  //14.640189
                let lng=Number( params[2] ) //-90.519828;

                if(isNaN(lat)===true || isNaN(lng)===true)
                {
                    alertas('No tiene coordenadas definidas', 'danger');
                } else {
                    $('#modal_map').modal('show');
    
                    map = new google.maps.Map(document.getElementById("googleMap"),{
                        center:new google.maps.LatLng(lat, lng),
                        zoom:14,
                    });
    
                    marker = new google.maps.Marker({
                        position: { lat: lat, lng:lng  },
                        map: map,
                        title: res.nombre,
                    });

                }
            }



        }
    }

}

function error(msg) {
    //var s = document.querySelector('#status');
    s.innerHTML = typeof msg == 'string' ? msg : "failed";
    s.className = 'fail';
    console.log(msg)
}

function btnVisitarCliActive()
{
    btnVisitarCli( t_cli.row(active_meta).data().id , active_meta)
}



function btnVisitarCli(id,row) {

    const IdVendedor = t_cli.row(row).data()['id_vendedor1'];
    const CodigoCliente = t_cli.row(row).data()['codigo'];    

    if (navigator.geolocation) {
        var options = {enableHighAccuracy: true,timeout: 5000,maximumAge: 0};
        if (typeof(idgeo) !== 'undefined') navigator.geolocation.clearWatch(idgeo)
        idgeo=navigator.geolocation.getCurrentPosition(function(position) { 

          Mycoords=position.coords.accuracy+"|"+position.coords.latitude+"|"+position.coords.longitude+"|"+id+"|"+IdVendedor+"|"+CodigoCliente;

          const url = base_url + 'clientes/registrarVisita/' + Mycoords;

          const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    //alertas(res.msg, res.icono);
                    t_cli.ajax.reload();

                }                
            }
          /*$.post( "lib/mysql_geolocalizacion_cliente.php",{idcliente:id,coord:Mycoords}, function(data) {
            //console.log(id, Mycoords)    
            load_grid(page_global)
          });*/

        }, error,options);
    } else {
      error('not supported');
    }

}



function btnVervisitaCli(id,row) {

    
    /*if(id===false) return*/
    form.classList.remove('was-validated');
    form.reset();
    $('#modal_anotaciones li a#tcontacto-tab').tab('show')

    const url = base_url + 'clientes/editar/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            
            id_cliente_anotaciones.value = res.id;
            console.log(res)

            if(res.coord_ultimavisita===null) {
                alertas('No tiene coordenadas definidas', 'danger');
            } else {
                let params = res.coord_ultimavisita.split('|');

                let lat=Number( params[1] );
                let lng=Number( params[2] );

                let paramse = res.visita.coordenadas.split('|');
                let lat_entrada=Number( paramse[1] );
                let lng_entrada=Number( paramse[2] );

                coordenadas_cliente.innerHTML = res.nombre;
                coordenadas_ultima_visita_entrada.innerHTML = `<span class="badge badge-warning ml-2">Latitud</span> ${lat_entrada} <span class="badge badge-warning ml-2">Longitud</span> ${lng_entrada} <span class="badge badge-warning ml-2">Fecha</span> ${res.visita.fecha}`;

                if(res.visita.anotaciones===null || res.visita.anotaciones==='') {
                    observaciones_visita.innerHTML = `<span class="text-muted">Sin observaciones</span>`;
                } else {
                    observaciones_visita.innerHTML = res.visita.anotaciones;
                }

                if(res.visita.fecha_salida===null) {
                    coordenadas_ultima_visita_salida.innerHTML = `<span class="ml-2">Sin salida</span>`;
                } else {
                    let paramss = res.visita.coordenadas_salida.split('|');
                    let lat_salida=Number( paramss[1] );
                    let lng_salida=Number( paramss[2] );                    
                    coordenadas_ultima_visita_salida.innerHTML = `<span class="badge badge-warning ml-2">Latitud</span> ${lat_salida} <span class="badge badge-warning ml-2">Longitud</span> ${lng_salida} <span class="badge badge-warning ml-2">Fecha</span> ${res.visita.fecha_salida}`;
                }

                if(isNaN(lat)===true || isNaN(lng)===true)
                {
                    alertas('No tiene coordenadas definidas', 'danger');
                } else {
                    $('#modal_map').modal('show');
    
                    map = new google.maps.Map(document.getElementById("googleMap"),{
                        center:new google.maps.LatLng(lat, lng),
                        zoom:14,
                    });
    
                    marker = new google.maps.Marker({
                        position: { lat: lat, lng:lng  },
                        map: map,
                        title: res.nombre,
                    });

                }
            }



        }
    }

}

function btnProgramarCliActive()
{
    btnProgramarCli( t_cli.row(active_meta).data().id , active_meta)
}

function btnCobrarCliActive()
{
    btnCobrarCli( t_cli.row(active_meta).data().id , active_meta)
}

function btnLlamarCliActive()
{
    btnLlamarCli( t_cli.row(active_meta).data().id , active_meta)
}

function btnProgramarCli(id,row) {
/*    console.log(`ID: ${id} ROW: ${row} `) ;
    console.log( `CODIGO: ${t_cli.row(row).data()['codigo']}`) ;
    console.log( `CLIENTE: ${t_cli.row(row).data()['contacto']}`) ;
    console.log( `VENDEDOR: ${t_cli.row(row).data()['id_vendedor1']}`) ;*/

    formProgramacion.classList.remove('was-validated');
    formProgramacion.reset();
    const validDate=(isValidDate(t_cli.row(row).data()['programacion'])===true)?t_cli.row(row).data()['programacion']:'2021-01-01';
    fechaProgramacion.value=validDate;
    
    idProgramacion.value = id;
    rowProgramacion.value = row;
    codigoClienteProgramacion.value = t_cli.row(row).data()['codigo'];
    nombreClienteProgramacion.value = t_cli.row(row).data()['nombre'];
    vendedorClienteProgramacion.value = t_cli.row(row).data()['id_vendedor1'];    

    $('#modal_programacion').modal('show');
}

function btnCobrarCli(id,row) {

    formCobro.classList.remove('was-validated');
    formCobro.reset();
    const validDate=(isValidDate(t_cli.row(row).data()['programacion'])===true)?t_cli.row(row).data()['programacion']:'2021-01-01';
    fechaCobro.value=validDate;
    
    idCobro.value = id;
    rowCobro.value = row;
    codigoClienteCobro.value = t_cli.row(row).data()['codigo'];
    nombreClienteCobro.value = t_cli.row(row).data()['nombre'];
    vendedorClienteCobro.value = t_cli.row(row).data()['id_vendedor1'];    

    $('#modal_cobro').modal('show');
}

function btnLlamarCli(id,row) {

    
    formLlamada.classList.remove('was-validated');
    formLlamada.reset();
    const validDate=(isValidDate(t_cli.row(row).data()['programacion'])===true)?t_cli.row(row).data()['programacion']:'2021-01-01';
    fechaLlamada.value=validDate;
    
    idLlamada.value = id;
    rowLlamada.value = row;
    codigoClienteLlamada.value = t_cli.row(row).data()['codigo'];
    nombreClienteLlamada.value = t_cli.row(row).data()['nombre'];
    vendedorClienteLlamada.value = t_cli.row(row).data()['id_vendedor1'];    

    $('#modal_llamada').modal('show');
}


function btnHistorialvisitasCli(id) {
    if(id===false) return
    window.open(base_url +'clientes/dashboardvisitas/'+id, "_blank");
}

function btnVentasCli(id) {
    if(id===false) return
    window.open(base_url +'clientes/dashboardventas/'+id, "_blank");
}

function isValidDate(dateString) {
    // First check for the pattern
    if (!/^\d{4}-\d{1,2}-\d{1,2}$/.test(dateString)) {
      return false;
    }
  
    // Parse the date parts to integers
    const parts = dateString.split("-");
    const year = parseInt(parts[0], 10);
    const month = parseInt(parts[1], 10);
    const day = parseInt(parts[2], 10);
  
    // Check the ranges of month and year
    if (year < 1000 || year > 3000 || month == 0 || month > 12) {
      return false;
    }
  
    const monthLength = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
  
    // Adjust for leap years
    if (year % 400 == 0 || (year % 100 != 0 && year % 4 == 0)) {
      monthLength[1] = 29;
    }
  
    // Check the range of the day
    return day > 0 && day <= monthLength[month - 1];
  }

function search_cliente()
{
    regex = '\\b' + vendedor.value + '\\b';

    if(vendedor.value!='') { t_cli.column(7).search(regex,true,false); } else { t_cli.column(7).search(''); }
    if(ruta.value!='') { t_cli.column(8).search(ruta.value, { exact: false }); } else { t_cli.column(8).search(''); }

    t_cli.draw();
}

function clean_search()
{
    vendedor.value = '';
    ruta.value = '';
    fecha_desde.value='';
    fecha_hasta.value='';
    filtro_fecha.value='';
    search_cliente();
}

document.addEventListener('DOMContentLoaded', function () {

    $.fn.dataTable.ext.search.push(function (settings, data, dataIndex) {
        if (filtro_fecha.value == '') { return true; }

        let FilterStart = fecha_desde.value;
        let FilterEnd = fecha_hasta.value;
        let DataTableStart = data[filtro_fecha.value].trim();
        let DataTableEnd = data[filtro_fecha.value].trim();

        if (FilterStart == '' || FilterEnd == '') { return true; }
        if (DataTableStart >= FilterStart && DataTableEnd <= FilterEnd) { return true; } else { return false; }
    });

});

function show_advanced_search() {
    clean_search();
    if(advanced_search_bool===false) {
        advanced_search.classList.remove('d-none');
        advanced_search_bool = true;
    } else {
        advanced_search.classList.add('d-none');
        advanced_search_bool = false;
    }
}

function calculateDateDifferenceInDays(date1, date2) {
    // Ensure input are Date objects
    const d1 = new Date(date1);
    const d2 = new Date(date2);
  
    // Set time to midnight UTC to avoid issues with timezones and daylight saving
    d1.setUTCHours(0, 0, 0, 0);
    d2.setUTCHours(0, 0, 0, 0);
  
    // Calculate the difference in milliseconds
    const diffTime = Math.abs(d2.getTime() - d1.getTime()); // Use Math.abs for positive difference
  
    // Convert milliseconds to days
    const diffDays = Math.floor(diffTime / (1000 * 60 * 60 * 24));
  
    return diffDays;
}