const year_chrats = document.getElementById('yearCharts');

//const nombre_cliente = document.getElementById('nombreCliente');
//const direccion_cliente = document.getElementById('direccionCliente');
//const limite_credito = document.getElementById('limitecreditoCliente');
//const dias_credito = document.getElementById('diascreditoCliente');
//const saldo_cliente = document.getElementById('saldoCliente');
//const vendedor_cliente = document.getElementById('vendedorCliente');
//const ultimaventa_cliente=document.getElementById('ultimaventaCliente');
//const ultimopago_cliente=document.getElementById('ultimopagoCliente');
//const ultimavisita_cliente=document.getElementById('ultimavisitaCliente');

const reporte_categorias = document.getElementById('tablaCategorias');
const reporte_productos = document.getElementById('tablaProductos');




let ventasChartObj=false;
let ventasChartCanvas=false;
let pagosChartObj=false;
let pagosChartCanvas=false;

let ventaspagosChartObj=false;
let ventaspagosChartCanvas=false;


let datosCharts={};

document.addEventListener('DOMContentLoaded', function(){
    iniciarReportes()
})




function iniciarReportes()
{
    reporte_categorias.innerHTML=`<div class="spinner-grow spinner-grow-sm mr-2" role="status"></div> <span class='text-secondary'>Cargando...</span>`;
    reporte_productos.innerHTML=``;

    const anio = year_chrats.value;
    if(idcliente===false) return;
    const url = base_url + 'clientes/reporteVentasCliente/' + anio +'/'+ idcliente;

    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);

            //console.log(res);

//            nombre_cliente.innerHTML=`[${res.id}] ${res.cliente.nombre}`;
//            direccion_cliente.innerHTML=`${res.cliente.direccion}`;
//            limite_credito.innerHTML=`<strong>Limite de Credito</strong></br>${res.limite_credito}`;
//            dias_credito.innerHTML=`<strong>Dias Credito</strong></br>${res.dias_credito}`;
//            saldo_cliente.innerHTML=`<strong>Saldo</strong></br>${res.saldo}`;
//            vendedor_cliente.innerHTML=`<strong>Vendedor</strong></br>${res.id_vendedor1}`;
//            ultimaventa_cliente.innerHTML=`<strong>Ultima Venta</strong></br>${res.ultimaventa}`;
//            ultimopago_cliente.innerHTML=`<strong>Ultimo Pago</strong></br>${res.ultimopago}`;
//            ultimavisita_cliente.innerHTML=`<strong>Ultima Visita</strong></br>${res.ultimavisita}`;


            actualizarTablaCategorias(res.categorias);
            actualizarTablaProductos(res.productos);
        }
    }
   
}

function actualizarTablaProductos(productos)
{
    if(productos.length==0)
    {
      reporte_productos.innerHTML=`<div class="alert alert-danger">No existen datos</div>`;
    } else {
      let tableHTML = `<table class='table table-sm table-striped'>
                    <thead class="thead-dark">
                        <tr class=''>
                            <th scope="col" class=''>CODIGO</th>
                            <th scope="col" class='text-right'>LINEA</th>
                            <th scope="col" class='text-right'>DESCRIPCION</th>
                            <th scope="col" class='text-right'>UNIDADES</th>
                            <th scope="col" class='text-right'>VENTA</th>                            
                        </tr>
                    </thead>
                    <tbody>`;

        productos.forEach(prod => {

          tableHTML += `
            <tr>
                <td style='line-height: 1em'>${prod.codart}</td>
                <td style='line-height: 1em'>${prod.cod_linea}</td>
                <td style='line-height: 1em'>${prod.prod_descrip}</td>
                <td style='line-height: 1em' class="text-right">${prod.cantidad !== undefined ? numFormat(prod.cantidad) : 'N/A'}</td>
                <td style='line-height: 1em' class="text-right">Q.${prod.ventas!== undefined ? numFormat(prod.ventas) : 'N/A'}</td>
            </tr>
          `;
        });

      tableHTML += `</tbody></table>`;
      reporte_productos.innerHTML = tableHTML;                    
    }

}

function actualizarTablaCategorias(categorias)
{
    let comprados=[];

    if(categorias.length==0)
    {
      /*reporte_categorias.innerHTML=`<div class="alert alert-danger">No existen datos</div>`;*/
      let tableHTML = `<table class='table table-sm table-striped'>
                    <thead class="thead-dark">
                        <tr class=''>
                            <th scope="col" >LINEA</th>
                            <th scope="col" >CATEGORIA</th>
                            <th scope="col" >UNIDADES</th>
                            <th scope="col" >VENTAS</th>
                        </tr>
                    </thead>
                    <tbody>`;
      let nocomprados = [...categoriasGeneral]
      nocomprados.forEach(categoria => {
                tableHTML += `
                  <tr class='text-danger'>
                      <td style='line-height: 1em'>${categoria.cod_linea}</td>
                      <td style='line-height: 1em'>${categoria.categoria}</td>
                      <td style='line-height: 1em' class="text-right">0</td>
                      <td style='line-height: 1em' class="text-right">Q.0.00</td>
                  </tr>
                `;
      });
            
      tableHTML += `</tbody></table>`;
      reporte_categorias.innerHTML = tableHTML;  
    } else {
      let tableHTML = `<table class='table table-sm table-striped'>
                    <thead class="thead-dark">
                        <tr class=''>
                            <th scope="col" >LINEA</th>
                            <th scope="col" >CATEGORIA</th>
                            <th scope="col" >UNIDADES</th>
                            <th scope="col" >VENTAS</th>
                        </tr>
                    </thead>
                    <tbody>`;
      categorias.forEach(categoria => {
        comprados.push(categoria.cod_linea);
        tableHTML += `
          <tr>
              <td style='line-height: 1em'>${categoria.cod_linea}</td>
              <td style='line-height: 1em'>${categoria.categoria}</td>
              <td style='line-height: 1em' class="text-right">${categoria.cantidad !== undefined ? numFormat(categoria.cantidad) : 'N/A'}</td>
              <td style='line-height: 1em' class="text-right">Q.${categoria.ventas!== undefined ? numFormat(categoria.ventas) : 'N/A'}</td>
          </tr>
        `;
      });
      nocomprados = categoriasGeneral.filter(categoria => !comprados.includes(categoria.cod_linea));
      
      nocomprados.forEach(categoria => {
          tableHTML += `
            <tr class='text-danger'>
                <td style='line-height: 1em'>${categoria.cod_linea}</td>
                <td style='line-height: 1em'>${categoria.categoria}</td>
                <td style='line-height: 1em' class="text-right">0</td>
                <td style='line-height: 1em' class="text-right">Q.0.00</td>
            </tr>
          `;
      });

      tableHTML += `</tbody></table>`;
      reporte_categorias.innerHTML = tableHTML;

    }

}

function numFormat(num) {
    return new Intl.
    NumberFormat("gt-GT").format(num)
}