let t_h_c;

let active_row=false;
let active_obj=false;

document.addEventListener('DOMContentLoaded', function () {
    //DataTables Historial Compras - Ajax
    t_h_c = $('#t_compras').DataTable({
        "aPreocesing": true,
        "aServerSide": false,
        "ajax": {
            "url": "" + base_url + 'compras/listar_historial',
            "dataSrc": ""
        },
        "columns": [{
            "data": "id"
        },
        {
            "data": "nombre"
        },
        {
            "data": "total"
        },
        {
            "data": "fecha"
        },
        {
            "data": "hora"
        },
        {
            "data": "forma"
        },
        {
            "data": "estado"
        }
        ],

        "drawCallback": function () {
            let api = this.api();
            $(api.columns(2).footer()).html(
                'Total:  Q.' + api.columns(2).data().sum().toFixed(2)
            )
            /*$(api.columns(2).footer()).html(
                'Total:  ' + api.columns(2, {
                    page: 'current'
                }).data().sum()
            ) */           
        },
        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [3, "desc"]
        ]

    });

    t_h_c.on( 'draw', function () {
        $('#t_compras tbody tr').removeClass('selected');
        activo_buttons(false)
    } );

    $('#t_compras tbody').on( 'click', 'tr', function (e) {
        let classList = e.currentTarget.classList;
       
        if (classList.contains('selected')) {
            classList.remove('selected');
        } else {
            t_h_c.rows('.selected').nodes().each((row) => row.classList.remove('selected'));
            classList.add('selected');
        }
        activo_buttons( t_h_c.row( this ).data()  );
    } );

    function activo_buttons(obj)
    {
        active_obj=obj;
        active_row=active_obj.id;

        if($('#t_compras tbody tr.selected').length==0)
        {
            $('BUTTON.btn-toolbar-status').attr('disabled', 'disabled');
        } else {
            $('BUTTON.btn-toolbar-status').removeAttr('disabled');
        }
    }

    $('#min').change(function (e) {
        t_h_c.draw();
    });
    //Busqueda por Rango de Fechas DataTables - Hasta
    $('#max').change(function (e) {
        t_h_c.draw();
    });
})

function btnPDF(id)
{
    window.open(base_url +'compras/generarPdf/'+id, "_blank");
}

function btnAnular(id) {
    Swal.fire({
        title: 'Esta seguro de anular la Compra?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = base_url + 'compras/anular/' + id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    alertas(res.msg, res.icono);
                    t_h_c.ajax.reload();
                }
            }

        }
    })
}