<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte</title>
    <link rel="stylesheet" href="<?php echo base_url . 'Assets/css/reporte.css'; ?>">
</head>

<body>
    <table id="datos-empresa">
        <tr>
            <td class="logo">
                <img src="<?php echo base_url . 'Assets/img/logo.png'; ?>" alt="" width="150">
            </td>
            <td class="info-empresa">
                <p><b><?php echo $data['empresa']['nombre']; ?></b></p>
            </td>
        </tr>
    </table>

    <h2 style='text-align:center;'>KARDEX</h2>

    <P style='font-size:3mm;'>
        <strong>CÓDIGO:</strong> <?php echo $data['producto']['id'] ?><br/>
        <strong>NOMBRE:</strong> <?php echo $data['producto']['descripcion'] ?>
    </P>


    <table cellspacing=0>
        <thead>
            <tr>
                <th class="text-left">FECHA</th>
                <th class="text-left">TIPO</th>
                <th class="text-left" style='white-space: nowrap;'>REFERENCIA</th>
                <th class="text-right">#&nbsp;DOC</th>
                <th class="text-right">CANTIDAD</th>
                <th class="text-right">EXISTENCIA</th>
            </tr>
            <tr class='blanco'>
                <th colspan='6'>&nbsp;</th>
            </tr>            
        </thead>
        <tbody>
            <?php
            $kardex=0;
            foreach ($data['kardex'] as $producto) {
                $kardex+=($producto['TIPO']=='COMPRA')?$producto['CANTIDAD']:($producto['CANTIDAD']*-1);
                ?>
                <tr>
                    <td><?=date('d/m/Y', strtotime($producto['FECHA']))?></td>    
                    <td class="text-left"><?=$producto['TIPO']?></td>
                    <td class="text-left" style='white-space: nowrap;'>(<?=$producto['IDREFERENCIA']?>) <?=$producto['REFERENCIA']?></td>
                    <td class="text-right"><?=$producto['DOCUMENTO']?></td>
                    <td class="text-right"><?=$producto['CANTIDAD']?></td>
                    <td class="text-right"><?=$kardex?></td>
                </tr>                
            <?php
                }
            ?>
          
        </tbody>
        <tfoot>
            <tr>
                <th colspan=3></th>
                <th colspan=2 class="text-right fborder">EXISTENCIA FINAL</th>
                <th class="text-right fborder"><?=$kardex?></th>
            </tr>
            <tr>
                <th colspan='3'></th>
                <th class="text-right fdborder" colspan='3'>&nbsp;</th>
            </tr>            
        </tfoot>
    </table>

</body>

</html>

<style type='text/css'>
THEAD TR TH {
    background: #ccc;
    border-top: 1px solid #000;
    padding-left:5mm;
    padding-right:5mm;
    font-size:3mm !important;
}


THEAD TR.blanco TH {
    background: #fff;
    border-bottom: 1px solid #000;
    height:2px;
    font-size:2px;
    line-height:2px;
}
.text-left { text-align:left; }
.text-right { text-align:right; }
TBODY TR TD {
    font-size:3mm !important;
    padding-top:0.5mm;
    padding-bottom:0.5mm;
    padding-left:5mm;
    padding-right:5mm;
}

TBODY TR TH {
    font-size:3mm;
    padding-top:0.5mm;
    padding-bottom:0.5mm;
    padding-left:5mm;
    padding-right:5mm;
    border-top:1px solid #000;
    border-bottom:1px solid #000;
}

TFOOT TR TH {
    padding-left:5mm;
    padding-right:5mm;
    font-size:3mm !important;
}
TFOOT TR TH.fborder {
    border-top: 1px solid #000;
    background: #ccc;
}
TFOOT TR TH.fdborder {
    border-top: 1px solid #000;
    border-bottom: 1px solid #000;
    height:2px;
    font-size:2px;
    line-height:2px;
}
</style>