// ============================================
// VARIABLES PRINCIPALES - OPTIMIZADAS
// ============================================
const btnProcesar = document.getElementById('btnProcesar');
//const contado = document.getElementById('contado');
//const credito = document.getElementById('credito');
const anotacion = document.getElementById('anotacion');
const form = document.getElementById('formulario');
//const serie = document.getElementById('serie');
//const vendedores = document.getElementById("vendedores");
const fecha = document.getElementById("fecha");

// ============================================
// VARIABLES DE CLIENTE SELECCIONADO - NUEVAS
// ============================================


let tipo_cliente_seleccionado = 0; // 0 = no seleccionado // 1 = cliente registrado // 2 = cliente mostrador

const id_cliente_seleccionado = document.getElementById('id_cliente_seleccionado');
const nombre_cliente_seleccionado = document.getElementById('nombre_cliente_seleccionado');
const tipoid_cliente_seleccionado = document.getElementById('tipoid_cliente_seleccionado');
const nit_cliente_seleccionado = document.getElementById('nit_cliente_seleccionado');
const direccion_cliente_seleccionado = document.getElementById('direccion_cliente_seleccionado');
const area_estadocliente = document.getElementById('area_estadocliente');


// ============================================
// VARIABLES DE CONTROL - SIMPLIFICADAS
// ============================================
let countAutocomplete = 0;
let timeoutBusqueda = null; // Variable para debounce en búsqueda de clientes

document.addEventListener('DOMContentLoaded', function () {
    cargarDetalle(true)

    // ============================================
    // AUTOCOMPLETE DE CLIENTES - COMENTADO (NO EXISTE buscarCliente EN LA VISTA)
    // ============================================
    /*
    $("#buscarCliente").autocomplete({
        minLength: 2,
        source: function (request, response) {
            $.ajax({
                url: base_url + 'clientes/buscarCliente',
                dataType: "json",
                data: {
                    q: request.term
                },
                success: function (data) {
                    response(data);
                }
            });
        },
        select: function (event, ui) {
            // Actualizar campos seleccionados en lugar de campos que no existen
            id_cliente_seleccionado.value = ui.item.id;
            nombre_cliente_seleccionado.value = ui.item.nombre;
            tipoid_cliente_seleccionado.value = ui.item.tipoid;
            nit_cliente_seleccionado.value = ui.item.nit;
            direccion_cliente_seleccionado.value = ui.item.direccion;
            vendedores.value = ui.item.vendedor;
        },
    })
    */
    //Autocomplete - Jquery UI, Buscar Productos para la Venta
    $("#buscarProducto").autocomplete({
        minLength: 2,
        classes: {"ui-autocomplete": "height-max-autocomplete"},
        source: function (request, response) {
            $.ajax({
                url: base_url + 'ventas/buscarProducto',
                dataType: "json",
                data: {
                    pro: request.term
                },
                success: function (data) {
                    if (data.length > 0) {
                        var result = Object.values(data);
                        response( Object.values(data) );
                    } else {
                        document.getElementById('error_producto').textContent = 'No hay Producto Similar';
                    }
                }
            });
        },
        response: function( event, ui ) { countAutocomplete=-1; },
        classes: { "ui-autocomplete": "autocompleteOverflow" },                
        select: function (event, ui) {
            document.getElementById('error_producto').textContent = '';
            const id_pro = ui.item.id;
            ingresarVenta(id_pro);
        },
        create: function (event,ui){

            $(this).autocomplete( "instance" )._renderItem = function (ul, item) {

                countAutocomplete++;                

                return $( "<li></li>" )
                .data("item.autocomplete", item)
                .append(`<div class='autocompleteProduct'>
                    <div class="row">
                        <div class='col-12 col-md-2'>
                       
                            <img src="https://ad.divemosa.com/inventario/Assets/img/pro/${item.foto}" 
                                 onerror="this.onerror=null; this.src='${base_url}Assets/img/pro/default.png';" 
                                 alt="Producto">
                        </div>
                        <div class='col-12 col-md-8'>
                            <h3 class='mb-0 '>${item.descripcion}</h3>
                            <p class='mb-0 d-none'>${item.detalles}</p>
                            <h4 class='mb-0'>
                                <span class="badge badge-warning">${item.value}</span>
                                <span class="badge badge-secondary">${item.value_alter}</span>
                            </h4>
                            <p class='mb-0 d-none'>${item.observaciones}</p>
                        </div>
                        <div class='col-12 col-md-2'>
                            <h2 class='text-right mb-0'><strong>Q.${item.precio}</strong></h2>
                            <h2 class='text-right'><span class="badge badge-danger">Existencia ${item.cantidad}</span></h6>
                        </div>
                    </div>
                </div>`)                
                /*.append(`<div class='autocompleteProduct'>
                    <div class="row">
                        <div class='col-12 col-md-2'>
                            <img src="https://ad.divemosa.com/inventario/Assets/img/pro/${item[countAutocomplete].foto}">
                        </div>
                        <div class='col-12 col-md-8'>
                            <h3 class='mb-0 '>${item[countAutocomplete].descripcion}</h3>
                            <p class='mb-0'>${item[countAutocomplete].detalles}</p>
                            <h4 class='mb-0'>
                                <span class="badge badge-warning">${item[countAutocomplete].codigo}</span>
                                <span class="badge badge-secondary">${item[countAutocomplete].codigo_alter}</span>
                            </h4>
                            <p class='mb-0'>${item[countAutocomplete].observaciones}</p>
                        </div>
                        <div class='col-12 col-md-2'>
                            <h2 class='text-right mb-0'><strong>Q.${item[countAutocomplete].precio_venta}</strong></h2>
                            <h2 class='text-right'><span class="badge badge-danger">Existencia ${item[countAutocomplete].cantidad}</span></h6>
                        </div>
                    </div>
                </div>`)*/
                .appendTo( ul );
            };
        }          
    })

    // ============================================
    // EVENT LISTENERS - OPTIMIZADOS
    // ============================================
    btnProcesar.addEventListener('click', generarVenta)
    // btnClientesHide.addEventListener('click', toggleClientes); // COMENTADO: Botones no usados
    // btnClientesShow.addEventListener('click', toggleClientes); // COMENTADO: Botones no usados

    // Establecer fecha actual
    //fecha.value = new Date().toISOString().substring(0, 10);

    // ============================================
    // MODAL DE NUEVO CLIENTE - MANTENIDO
    // ============================================

    var forms = document.getElementsByClassName('needs-validation');
    // Loop over them and prevent submission
    var validation = Array.prototype.filter.call(forms, function (form) {
        form.addEventListener('submit', function (event) {
            event.preventDefault();
            if (form.checkValidity() === false) {
                event.stopPropagation();
                form.classList.add('was-validated');
            } else {
                const url = base_url + 'clientes/registrar';
                const http = new XMLHttpRequest();
                http.open("POST", url, true);
                http.send(new FormData(this));
                http.onreadystatechange = function () {
                    if (this.readyState == 4 && this.status == 200) {
                        const res = JSON.parse(this.responseText);
                        alertas(res.msg, res.icono);
                        if (res.icono == 'success') {
                            $('#nuevo_cliente').modal('hide');
                        }
                    }
                }
            }

        }, false);
    });

})

// ============================================
// FUNCIONES COMENTADAS - NO UTILIZADAS
// ============================================

// FUNCIÓN COMENTADA: toggleClientes - Elementos no existen en la vista actual
/*
function toggleClientes()
{
    showCliente=!showCliente;
    if(showCliente===true)
    {
        btnClientesHide.classList.remove("d-none")
        btnClientesShow.classList.add("d-none")
        areaCliente.classList.remove("d-none")
        areaClienteMinimizado.classList.add("d-none")
    } else {
        btnClientesHide.classList.add("d-none")
        btnClientesShow.classList.remove("d-none")
        areaCliente.classList.add("d-none")
        areaClienteMinimizado.classList.remove("d-none")
        let nombre_cliente=(customCheck.checked===true)?nombreCliente.value:buscarCliente.value;
        if(nombre_cliente.toString().trim()=='') nombre_cliente='No seleccionado'
        areaClienteMinimizado.innerHTML=`
            <p class='mb-0'>
            <span class='mr-1'><strong>Cliente:</strong> ${nombre_cliente}</span>
            <span class="badge badge-secondary mr-1">Serie: ${(serie.value=='1')?'AD':'DIVEMOSA'}</span>
            </p>
        `
    }  
}
*/

// FUNCIÓN COMENTADA: clienteCustom - Elementos no existen en la vista actual
/*
function clienteCustom(logic)
{
    buscarCliente.value='';
    nombreCliente.value='';
    document.getElementById('id_cliente').value = 1;
    document.getElementById('id_cliente_badge').innerHTML = '';
    document.getElementById('tipoid_cliente').value = 1;
    document.getElementById('nit_cliente').value = 'CF';
    document.getElementById('direccion_cliente').value = 'GUATEMALA, CIUDAD';
    if(logic===true)
    {
        id_cliente.value=0;
        buscarClienteContainer.classList.add("d-none");
        ClienteContainer.classList.remove("d-none");
    } else {
        id_cliente.value=1;
        buscarClienteContainer.classList.remove("d-none");
        ClienteContainer.classList.add("d-none");
    }
}
*/

function verStatusCliente(id)
{
    if(id===false) return;
    
    const url = base_url + 'clientes/editar/' + id;

    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {

            const res = JSON.parse(this.responseText);


            let class_limite_credito=(Number(res.saldo)>Number(res.limite_credito)) ? 'danger' : 'info';
            let class_dias_credito= (Number(res.facturas_vencidas)>0) ? 'danger' : 'info';
            let class_saldo_cliente= (Number(res.saldo)>Number(res.limite_credito)) ? 'danger' : 'success';
            let class_ultimaventa_cliente = (diasDesde( res.ultimaventa ) < 30) ? 'success' : (diasDesde( res.ultimaventa ) < 60) ? 'warning' : 'danger';
            let class_ultimopago_cliente = (diasDesde( res.ultimopago ) < 30) ? 'success' : (diasDesde( res.ultimopago ) < 60) ? 'warning' : 'danger';
            let class_ultimavisita_cliente = (diasDesde( res.ultimavisita ) < 30) ? 'success' : (diasDesde( res.ultimavisita ) < 60) ? 'warning' : 'danger';

            area_estadocliente.innerHTML=`
            <div class='d-none d-md-block'>
                <div class="d-flex flex-wrap" style="gap: 4px;">
                    <button type="button" class="btn btn-${class_limite_credito}" style="font-size:0.7rem; padding:2px 6px; line-height:1.2;"><strong>Límite</strong><br>Q${res.limite_credito}</button>
                    <button type="button" class="btn btn-${class_dias_credito}" style="font-size:0.7rem; padding:2px 6px; line-height:1.2;"><strong>Días</strong><br>${res.dias_credito}</button>
                    <button type="button" class="btn btn-${class_saldo_cliente}" style="font-size:0.7rem; padding:2px 6px; line-height:1.2;"><strong>Saldo</strong><br>Q${res.saldo}</button>
                    <button type="button" class="btn btn-primary" style="font-size:0.7rem; padding:2px 6px; line-height:1.2;"><strong>Vendedor</strong><br>${res.id_vendedor1}</button>
                    <button type="button" class="btn btn-${class_ultimaventa_cliente}" style="font-size:0.7rem; padding:2px 6px; line-height:1.2;"><strong>Últ. Venta</strong><br>${mostrarfecha(res.ultimaventa)}</button>
                    <button type="button" class="btn btn-${class_ultimopago_cliente}" style="font-size:0.7rem; padding:2px 6px; line-height:1.2;"><strong>Últ. Pago</strong><br>${mostrarfecha(res.ultimopago)}</button>
                    <button type="button" class="btn btn-${class_ultimavisita_cliente}" style="font-size:0.7rem; padding:2px 6px; line-height:1.2;"><strong>Últ. Visita</strong><br>${mostrarfecha(res.ultimavisita,true)}</button>
                </div>
            </div>

            <ul class="list-group d-md-none" style="font-size:0.8rem;">
                <li class="list-group-item d-flex justify-content-between align-items-center list-group-item-${class_limite_credito}" style='line-height:0.8em; padding:0.3rem 0.5rem;'><strong>Límite</strong><span class="badge badge-dark badge-pill">Q${res.limite_credito}</span></li>
                <li class="list-group-item d-flex justify-content-between align-items-center list-group-item-${class_dias_credito}" style='line-height:0.8em; padding:0.3rem 0.5rem;'><strong>Días</strong><span class="badge badge-dark badge-pill">${res.dias_credito}</span></li>
                <li class="list-group-item d-flex justify-content-between align-items-center list-group-item-${class_saldo_cliente}" style='line-height:0.8em; padding:0.3rem 0.5rem;'><strong>Saldo</strong><span class="badge badge-dark badge-pill">Q${res.saldo}</span></li>
                <li class="list-group-item d-flex justify-content-between align-items-center list-group-item-primary" style='line-height:0.8em; padding:0.3rem 0.5rem;'><strong>Vendedor</strong><span class="badge badge-dark badge-pill">${res.id_vendedor1}</span></li>
                <li class="list-group-item d-flex justify-content-between align-items-center list-group-item-${class_ultimaventa_cliente}" style='line-height:0.8em; padding:0.3rem 0.5rem;'><strong>Últ. Venta</strong><span class="badge badge-dark badge-pill">${mostrarfecha(res.ultimaventa)}</span></li>
                <li class="list-group-item d-flex justify-content-between align-items-center list-group-item-${class_ultimopago_cliente}" style='line-height:0.8em; padding:0.3rem 0.5rem;'><strong>Últ. Pago</strong><span class="badge badge-dark badge-pill">${mostrarfecha(res.ultimopago)}</span></li>
                <li class="list-group-item d-flex justify-content-between align-items-center list-group-item-${class_ultimavisita_cliente}" style='line-height:0.8em; padding:0.3rem 0.5rem;'><strong>Últ. Visita</strong><span class="badge badge-dark badge-pill">${mostrarfecha(res.ultimavisita,true)}</span></li>
            </ul>`;
        }
    }    
}

function diasDesde(fechaString) {
  const fecha = new Date(fechaString);
  const hoy = new Date();
  // Limpiar horas para comparar solo fechas
  fecha.setHours(0,0,0,0);
  hoy.setHours(0,0,0,0);
  const diferenciaMs = hoy - fecha;
  const dias = Math.floor(diferenciaMs / (1000 * 60 * 60 * 24));
  return dias;
}

function mostrarfecha(fechasinformato, hora=false)
{
   const opcionesFecha =(hora===true)?{ year: 'numeric',month: '2-digit',day: '2-digit',hour: '2-digit',minute: '2-digit',second: '2-digit', hour12: false}:{ year: 'numeric',month: '2-digit',day: '2-digit'};
   const fecha = new Date(fechasinformato);
   return fecha.toLocaleDateString('es-ES', opcionesFecha)
}

// ============================================
// FUNCIÓN OPTIMIZADA: frmCliente - MANTENIDA
// ============================================
function frmCliente() {
    document.getElementById('id').value = '';
    document.getElementById('title').textContent = 'Nuevo Cliente';
    document.getElementById('btnAccion').textContent = 'Registrar';
    form.reset();
    $('#nuevo_cliente').modal('show');
}

function ingresarVenta(id_pro) {
    const url = base_url + 'ventas/ingresar/' + id_pro;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {

            const res = JSON.parse(this.responseText);

            cargarDetalle();
            document.getElementById('buscarProducto').value = '';
            document.getElementById('buscarProducto').focus();
            alertas(res.msg, res.icono);
            return false;
        }
    }
}

function cantidadVenta(e, id) {
    const url = base_url + 'ventas/cantidadVenta/' + id + '/' + e.target.value;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            if (res.icono != 'success') {
                alertas(res.msg, res.icono);
            }
            cargarDetalle();
            return false;
        }
    }
}

function cargarDetalle(loadSelect=false) {

    const url = base_url + 'ventas/listar/detalle_temp';
    const http = new XMLHttpRequest();
    //let select = document.getElementById('serie');
    let option =null;

    let bgcebra ='bg-light';

    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);

            let html = '';
            res.detalle.forEach(row => {
                bgcebra=(bgcebra=='')?'bg-light':'';
                html += `
                <tr class='${bgcebra}'>
                    <td class='d-table-cell d-md-none p-2' style='border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;'> 
                        <img src="${base_url}/Assets/img/pro/${row['foto']}" 
                             style='width:100px;border:1px solid #eee;border-radius: 5px;'
                             onerror="this.onerror=null; this.src='${base_url}Assets/img/pro/default.png';" 
                             alt="Producto">
                    </td>
                    <td colspan='4' class='d-table-cell d-md-none' style='text-align:left;vertical-align:top;border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;'>
                        <h5 class='text-primary pl-2 pr-2' style='font-weight:bold;'>${row['descripcion']}</h5>    
                    </td>
                </tr>
                <tr class='${bgcebra}'>
                    <td class='d-none d-md-table-cell p-2' style='border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;width:155px;'>
                    
                        <img src="${base_url}/Assets/img/pro/${row['foto']}" 
                             style='width:125px;border:1px solid #eee;border-radius: 5px;'
                             onerror="this.onerror=null; this.src='${base_url}Assets/img/pro/default.png';" 
                             alt="Producto">
                    </td>
                    <td class='d-none d-md-table-cell' style='text-align:left;vertical-align:top;border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;'>
                        <h5 class='text-primary' style='font-weight:bold;'>${row['descripcion']}</h5>    
                        <h5 class='text-dark' style='font-weight:bold;'>Q.${row['sub_total']}</h5>
                    </td>
                    <td class='pl-2' style='text-align:center;vertical-align:top;border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;width:100px;'>
                        <small class='text-muted' style='font-size:10px;'>CANTIDAD</small>
                        <input type="text" class="form-control" min="1" value="${row['cantidad']}" onchange="cantidadVenta(event, ${row['id']})">
                    </td>

                    <td style='text-align:center;vertical-align:top;border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;width:100px;'>
                        <small class='text-muted' style='font-size:10px;'>PRECIO</small>
                        <input type="text" class="form-control input_precios" step="1.00" min="${row['precio_venta']}" value="${row['precio']}" onchange="precioProducto(event, ${row['id']})" required>
                    </td>

                    <td style='text-align:center;vertical-align:top;border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;width:100px;'>
                        <small class='text-muted' style='font-size:10px;'>DESCUENTO</small>
                        <input type="text" class="form-control" step="0.01" min="0.01" value="${row['descuento']}" onchange="descuentoVenta(event, ${row['id']})">
                    </td>

                    <td style='text-align:center;vertical-align:top;border-top:1px solid #eee;padding-top:34px;padding-bottom:10px;width:60px;'>
                        <button class="btn btn-danger" type="button" onclick="eliminar(${row['id']})"><i class="fas fa-trash-alt"></i></button>                    
                    </td>
                </tr>
                <tr class='${bgcebra}'>
                    <td colspan='4' class='d-table-cell d-md-none' style='text-align:left;vertical-align:top;border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;'>
                        <h5 class='text-dark pl-2' style='font-weight:bold;'><small class='font-weight-normal'>TOTAL</small> Q.${row['sub_total']}</h5>
                    </td>
                </tr>`;
               //https://ad.sismosoluciones.com/Assets/img/pro/default.png               
            });
            document.getElementById("t_ven").innerHTML = html;
            document.getElementById("total").value = res.total_pagar.total;

            /*if(loadSelect===true)
            {
                let selectedOption = select.value;
                select.innerHTML = '';          
                res.series.forEach(row => {
                    option = document.createElement('option');
                    option.value = row['iduser'];
                    option.text = `[${row['iduser']}] ${row['user']}`;
                    select.appendChild(option);
                });
            }*/

            /*let selectedOptionVendedores = vendedores.value;
            vendedores.innerHTML = '';          
            res.vendedores.forEach(row => {
                option = document.createElement('option');
                option.value = row['codven'];
                option.text = `[${row['codven']}] ${row['nombre']}`;
                vendedores.appendChild(option);
            });

            if(selectedOptionVendedores!='') vendedores.value=selectedOptionVendedores;*/

        }
    }
}

function precioProducto(e, id) {
    if(Number(e.target.value)<Number(e.target.min)) {
        alertas('El precio no puede ser menor al precio de venta', 'warning');
        e.target.value = e.target.min;
    }

    const url = base_url + 'ventas/precioProducto/' + id + '/' + e.target.value;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            cargarDetalle();
            alertas(res.msg, res.icono);
        }
    }
}

function descuentoVenta(e, id) {
    const url = base_url + 'ventas/descuentoVenta/' + id + '/' + e.target.value;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            alertas(res.msg, res.icono);
            cargarDetalle();
            return false;
        }
    }
}

function clienteCustom(logic)
{
    buscarCliente.value='';
    nombreCliente.value='';

    document.getElementById('id_cliente').value = 1;
    document.getElementById('id_cliente_badge').innerHTML = '';
    document.getElementById('tipoid_cliente').value = 1;
    document.getElementById('nit_cliente').value = 'CF';
    document.getElementById('direccion_cliente').value = 'GUATEMALA, CIUDAD';

    if(logic===true)
    {
        id_cliente.value=0;
        buscarClienteContainer.classList.add("d-none");
        ClienteContainer.classList.remove("d-none");
    } else {
        id_cliente.value=1;
        buscarClienteContainer.classList.remove("d-none");
        ClienteContainer.classList.add("d-none");
    }
}


function eliminar(id) {
    const url = base_url + 'ventas/delete/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            alertas(res.msg, res.icono);
            cargarDetalle();
        }
    }
}

function generarVenta(e) {
    e.preventDefault();
    Swal.fire({
        title: 'Esta seguro de procesar la Venta?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            let fila = document.querySelectorAll("#t_ventas_hist tr").length;

            if (fila < 1) {
                alertas('No hay productos para proceder con la venta', 'warning');
                return false;
            } else {
                const url = base_url + 'ventas/generarVenta';
                const data = new FormData();
                
                // ============================================
                // DATOS DE CLIENTE - USANDO CAMPOS SELECCIONADOS
                // ============================================
                data.append('id_cliente', id_cliente_seleccionado.value);
                data.append('nombre_cliente', nombre_cliente_seleccionado.value);
                data.append('tipoid', tipoid_cliente_seleccionado.value);
                data.append('nit', nit_cliente_seleccionado.value);
                data.append('direccion', direccion_cliente_seleccionado.value);
                data.append('mostrador', 0); // Siempre cliente registrado
                
                // ============================================
                // DATOS DEL PEDIDO
                // ============================================
                //data.append('credito', credito.checked);
                //data.append('contado', contado.checked);
                //data.append('serie', serie.value);
                data.append('anotacion', anotacion.value);
                //data.append('id_vendedor', vendedores.value);
                data.append('fecha', fecha.value);

                const http = new XMLHttpRequest();
                http.open("POST", url, true);
                http.send(data);
                http.onreadystatechange = function () {
                    if (this.readyState == 4 && this.status == 200) {
                        const res = JSON.parse(this.responseText);
                        alertas(res.msg, res.icono);
                        if (res.folio) {
                            let ruta;
                            if (tipoPdf) {
                                ruta = base_url + 'ventas/ticket/' + res.folio;
                            } else {
                                ruta = base_url + 'ventas/generarPdf/' + res.folio;
                            }
                            window.open(ruta);
                            setTimeout(() => {
                                window.location.reload();
                            }, 2000);
                        }
                    }
                }
            }
        }
    })
}

// ============================================
// FUNCIONES DE SELECCIÓN DE CLIENTE - NUEVAS
// ============================================

/**
 * Muestra el popup SweetAlert2 con las opciones de cliente
 */
function mostrarOpcionesCliente() {
    Swal.fire({
        title: 'Seleccionar Cliente',
        text: '¿Qué tipo de cliente?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#28a745',
        confirmButtonText: '<i class="fas fa-search mr-1"></i>Buscar',
        cancelButtonText: '<i class="fas fa-user-plus mr-1"></i>Mostrador',
        reverseButtons: true,
        customClass: {
            popup: 'swal2-small',
            confirmButton: 'btn btn-primary btn-sm mx-1',
            cancelButton: 'btn btn-success btn-sm mx-1'
        },
        buttonsStyling: false,
        width: '350px',
        padding: '1rem'
    }).then((result) => {
        if (result.isConfirmed) {
            // Usuario seleccionó "Buscar Cliente" (registrado)
            buscarClienteRegistrado();
        } else if (result.dismiss === Swal.DismissReason.cancel) {
            // Usuario seleccionó "Cliente Mostrador"
            crearClienteMostrador();
        }
    });
}

/**
 * Función para buscar cliente registrado
 */
function buscarClienteRegistrado() {
    Swal.fire({
        title: 'Buscar Cliente Registrado',
        html: `
            <div class="text-left">
                <div class="form-group mb-3">
                    <label for="swal_buscar_cliente" class="form-label">Buscar Cliente</label>
                    <input id="swal_buscar_cliente" class="form-control" type="text" 
                           placeholder="Escriba nombre, NIT o teléfono..." autocomplete="off">
                </div>
                <div id="resultados_busqueda" class="mt-3" style="max-height: 300px; overflow-y: auto;">
                    <small class="text-muted">Escriba al menos 2 caracteres para buscar...</small>
                </div>
            </div>
        `,
        showCancelButton: true,
        confirmButtonText: 'Cancelar',
        showConfirmButton: false,
        cancelButtonText: 'Cerrar',
        cancelButtonColor: '#6c757d',
        customClass: {
            popup: 'swal2-small',
            cancelButton: 'btn btn-secondary btn-sm'
        },
        buttonsStyling: false,
        width: '500px',
        padding: '1rem',
        didOpen: () => {
            // Hacer focus en el campo de búsqueda
            const inputBuscar = document.getElementById('swal_buscar_cliente');
            const resultadosDiv = document.getElementById('resultados_busqueda');
            inputBuscar.focus();
            
            // Event listener para búsqueda en tiempo real con debounce
            inputBuscar.addEventListener('input', function() {
                const termino = this.value.trim();
                
                // Cancelar búsqueda anterior si existe
                if (timeoutBusqueda) {
                    clearTimeout(timeoutBusqueda);
                    timeoutBusqueda = null;
                }
                
                if (termino.length < 2) {
                    resultadosDiv.innerHTML = '<small class="text-muted">Escriba al menos 2 caracteres para buscar...</small>';
                    return;
                }
                
                // Mostrar estado de "esperando..."
                resultadosDiv.innerHTML = '<div class="text-center"><i class="fas fa-clock"></i> Esperando...</div>';
                
                // Configurar nuevo timeout de 1 segundo
                timeoutBusqueda = setTimeout(() => {
                    // Mostrar spinner de carga
                    resultadosDiv.innerHTML = '<div class="text-center"><i class="fas fa-spinner fa-spin"></i> Buscando...</div>';
                    
                    // Realizar búsqueda AJAX
                    $.ajax({
                        url: base_url + 'clientes/buscarCliente',
                        dataType: "json",
                        data: { q: termino },
                        success: function(data) {
                            if (data && data.length > 0) {
                                let html = '<div class="list-group">';
                                data.forEach(cliente => {
                                    // Usar los nombres exactos de los campos que devuelve el servidor
                                    const id = cliente.id;
                                    const nombre = cliente.value; // El nombre está en el campo 'value'
                                    const tipoid = cliente.tipoid;
                                    const nit = cliente.nit;
                                    const direccion = cliente.direccion;
                                    
                                    // Determinar el tipo de documento basado en tipoid
                                    let tipoDocumento = "NIT";
                                    switch(tipoid.toString()) {
                                        case '1':
                                            tipoDocumento = "NIT";
                                            break;
                                        case '2':
                                            tipoDocumento = "CUI";
                                            break;
                                        case '3':
                                            tipoDocumento = "PASAPORTE";
                                            break;
                                        default:
                                            tipoDocumento = "DOC";
                                    }
                                    
                                    html += `
                                        <div class="list-group-item list-group-item-action p-2" 
                                             style="cursor: pointer;" 
                                             onclick="seleccionarClienteEncontrado('${id}', '${nombre}', '${tipoid}', '${nit}', '${direccion}')">
                                            <div class="d-flex w-100 justify-content-between">
                                                <h6 class="mb-0"><strong>${nombre}</strong></h6>
                                                <small class="text-muted">ID: ${id}</small>
                                            </div>
                                            <p class="mb-0"><strong>${tipoDocumento}:</strong> ${nit}</p>
                                            <small class="text-muted">${direccion}</small>
                                        </div>
                                    `;
                                });
                                html += '</div>';
                                resultadosDiv.innerHTML = html;
                            } else {
                                resultadosDiv.innerHTML = '<div class="alert alert-info mb-0">No se encontraron clientes con ese criterio.</div>';
                            }
                        },
                        error: function() {
                            resultadosDiv.innerHTML = '<div class="alert alert-danger mb-0">Error al buscar clientes. Intente nuevamente.</div>';
                        }
                    });
                }, 500); // Delay de 1 segundo
            });
        }
    });
}

/**
 * Función para seleccionar un cliente encontrado en la búsqueda
 */
function seleccionarClienteEncontrado(id, nombre, tipoid, nit, direccion) {
    // Cerrar el SweetAlert actual
    Swal.close();
    
    // Establecer cliente registrado con tipo 1 (NO editable)
    establecerCliente(
        id,
        nombre,
        tipoid,
        nit,
        direccion,
        1 // Tipo 1 = Cliente Registrado
    );
    
    // NO abrir formulario de edición para clientes registrados
    // Solo mostrar la información del cliente seleccionado
}

/**
 * Función para editar cliente registrado (todos los campos excepto ID son editables)
 */
function editarClienteRegistrado() {
    // Obtener valores actuales
    const idActual = id_cliente_seleccionado.value;
    const nombreActual = nombre_cliente_seleccionado.value;
    const tipoidActual = tipoid_cliente_seleccionado.value;
    const nitActual = nit_cliente_seleccionado.value;
    const direccionActual = direccion_cliente_seleccionado.value;
    
    Swal.fire({
        title: 'Editar Cliente Registrado',
        html: `
            <div class="text-left">
                <div class="form-group mb-3">
                    <label for="swal_nombre_cliente_edit" class="form-label">
                        Nombre Cliente <span class="text-danger">*</span> 
                        <span class="badge badge-info ml-2">ID: ${idActual}</span>
                    </label>
                    <input id="swal_nombre_cliente_edit" class="form-control" type="text" value="${nombreActual}" placeholder="Nombre del cliente" required>
                </div>
                
                <div class="form-group mb-3">
                    <label for="swal_tipoid_cliente_edit" class="form-label">Tipo <span class="text-danger">*</span></label>
                    <select class="form-control" id="swal_tipoid_cliente_edit" name="tipoid_cliente" required>
                        <option value="1" ${tipoidActual === "1" ? "selected" : ""}>NIT</option>
                        <option value="2" ${tipoidActual === "2" ? "selected" : ""}>CUI</option>
                        <option value="3" ${tipoidActual === "3" ? "selected" : ""}>PASAPORTE</option>
                    </select>
                </div>
                
                <div class="form-group mb-3">
                    <label for="swal_nit_cliente_edit" class="form-label" id="swal_label_nit_edit">NIT <span class="text-danger">*</span></label>
                    <input id="swal_nit_cliente_edit" class="form-control" type="text" value="${nitActual}" placeholder="NIT/DPI/PASAPORTE" required>
                </div>
                
                <div class="form-group mb-3">
                    <label for="swal_direccion_cliente_edit" class="form-label">Dirección <span class="text-danger">*</span></label>
                    <input id="swal_direccion_cliente_edit" class="form-control" type="text" value="${direccionActual}" placeholder="Dirección" required>
                </div>
            </div>
        `,
        showCancelButton: true,
        confirmButtonText: 'Guardar Cambios',
        cancelButtonText: 'Cancelar',
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#6c757d',
        customClass: {
            popup: 'swal2-small',
            confirmButton: 'btn btn-success btn-sm mx-1',
            cancelButton: 'btn btn-secondary btn-sm mx-1'
        },
        buttonsStyling: false,
        width: '500px',
        didOpen: () => {
            // Hacer focus en el campo nombre del cliente
            document.getElementById('swal_nombre_cliente_edit').focus();
            
            // Agregar event listener para cambiar el label dinámicamente
            const selectTipo = document.getElementById('swal_tipoid_cliente_edit');
            const labelNit = document.getElementById('swal_label_nit_edit');
            const inputNit = document.getElementById('swal_nit_cliente_edit');
            
            // Función para actualizar label y placeholder
            function actualizarCampoNIT() {
                const tipoSeleccionado = selectTipo.value;
                switch(tipoSeleccionado) {
                    case '1': // NIT
                        labelNit.innerHTML = 'NIT <span class="text-danger">*</span>';
                        inputNit.placeholder = 'Número de NIT';
                        break;
                    case '2': // CUI
                        labelNit.innerHTML = 'CUI <span class="text-danger">*</span>';
                        inputNit.placeholder = 'Código Único de Identificación';
                        break;
                    case '3': // PASAPORTE
                        labelNit.innerHTML = 'PASAPORTE <span class="text-danger">*</span>';
                        inputNit.placeholder = 'Número de Pasaporte';
                        break;
                }
            }
            
            // Establecer el label inicial basado en el valor actual
            actualizarCampoNIT();
            
            // Agregar listener para cambios en el select
            selectTipo.addEventListener('change', actualizarCampoNIT);
        },
        preConfirm: () => {
            const nombre = document.getElementById('swal_nombre_cliente_edit').value;
            const tipoid = document.getElementById('swal_tipoid_cliente_edit').value;
            const nit = document.getElementById('swal_nit_cliente_edit').value;
            const direccion = document.getElementById('swal_direccion_cliente_edit').value;
            
            // Validar nombre (obligatorio)
            if (!nombre.trim()) {
                Swal.showValidationMessage('El nombre del cliente es requerido');
                return false;
            }
            
            // Validar NIT/CUI/PASAPORTE (obligatorio)
            if (!nit.trim()) {
                const tipoTexto = tipoid === '1' ? 'NIT' : tipoid === '2' ? 'CUI' : 'PASAPORTE';
                Swal.showValidationMessage(`El ${tipoTexto} es requerido`);
                return false;
            }
            
            // Validar dirección (obligatoria)
            if (!direccion.trim()) {
                Swal.showValidationMessage('La dirección es requerida');
                return false;
            }
            
            return {
                id: idActual, // El ID no cambia
                nombre: nombre.trim(),
                tipoid: tipoid,
                nit: nit.trim(),
                direccion: direccion.trim()
            };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const datos = result.value;
            
            // Actualizar cliente registrado manteniendo tipo 1
            establecerCliente(
                datos.id, // Mantener el mismo ID
                datos.nombre,
                datos.tipoid,
                datos.nit,
                datos.direccion,
                1 // Mantener tipo 1 = Cliente Registrado
            );
        }
    });
}

/**
 * Función para crear cliente mostrador (por implementar)
 */
function crearClienteMostrador() {
    // Obtener valores actuales para edición
    const nombreActual = nombre_cliente_seleccionado.value !== "Nombre del Cliente" ? nombre_cliente_seleccionado.value : "";
    const tipoidActual = tipoid_cliente_seleccionado.value;
    const nitActual = nit_cliente_seleccionado.value !== "CF" ? nit_cliente_seleccionado.value : "CF";
    const direccionActual = direccion_cliente_seleccionado.value !== "Direccion del Cliente" ? direccion_cliente_seleccionado.value : "GUATEMALA, CIUDAD";
    
    Swal.fire({
        title: 'Cliente Mostrador',
        html: `
            <div class="text-left">
                <div class="form-group mb-3">
                    <label for="swal_nombre_cliente" class="form-label">Nombre Cliente <span class="text-danger">*</span></label>
                    <input id="swal_nombre_cliente" class="form-control" type="text" value="${nombreActual}" placeholder="Nombre del cliente" required>
                </div>
                
                <div class="form-group mb-3">
                    <label for="swal_tipoid_cliente" class="form-label">Tipo <span class="text-danger">*</span></label>
                    <select class="form-control" id="swal_tipoid_cliente" name="tipoid_cliente" required>
                        <option value="1" ${tipoidActual === "1" ? "selected" : ""}>NIT</option>
                        <option value="2" ${tipoidActual === "2" ? "selected" : ""}>CUI</option>
                        <option value="3" ${tipoidActual === "3" ? "selected" : ""}>PASAPORTE</option>
                    </select>
                </div>
                
                <div class="form-group mb-3">
                    <label for="swal_nit_cliente" class="form-label" id="swal_label_nit">NIT <span class="text-danger">*</span></label>
                    <input id="swal_nit_cliente" class="form-control" type="text" value="${nitActual}" placeholder="NIT/DPI/PASAPORTE" required>
                </div>
                
                <div class="form-group mb-3">
                    <label for="swal_direccion_cliente" class="form-label">Dirección <span class="text-danger">*</span></label>
                    <input id="swal_direccion_cliente" class="form-control" type="text" value="${direccionActual}" placeholder="Dirección" required>
                </div>
            </div>
        `,
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonText: 'Cancelar',
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#6c757d',
        customClass: {
            popup: 'swal2-small',
            confirmButton: 'btn btn-success btn-sm mx-1',
            cancelButton: 'btn btn-secondary btn-sm mx-1'
        },
        buttonsStyling: false,
        width: '500px',
        didOpen: () => {
            // Hacer focus en el campo nombre del cliente
            document.getElementById('swal_nombre_cliente').focus();
            
            // Agregar event listener para cambiar el label dinámicamente
            const selectTipo = document.getElementById('swal_tipoid_cliente');
            const labelNit = document.getElementById('swal_label_nit');
            const inputNit = document.getElementById('swal_nit_cliente');
            
            // Función para actualizar label y placeholder
            function actualizarCampoNIT() {
                const tipoSeleccionado = selectTipo.value;
                switch(tipoSeleccionado) {
                    case '1': // NIT
                        labelNit.innerHTML = 'NIT <span class="text-danger">*</span>';
                        inputNit.placeholder = 'Número de NIT';
                        break;
                    case '2': // CUI
                        labelNit.innerHTML = 'CUI <span class="text-danger">*</span>';
                        inputNit.placeholder = 'Código Único de Identificación';
                        break;
                    case '3': // PASAPORTE
                        labelNit.innerHTML = 'PASAPORTE <span class="text-danger">*</span>';
                        inputNit.placeholder = 'Número de Pasaporte';
                        break;
                }
            }
            
            // Establecer el label inicial basado en el valor actual
            actualizarCampoNIT();
            
            // Agregar listener para cambios en el select
            selectTipo.addEventListener('change', actualizarCampoNIT);
        },
        preConfirm: () => {
            const nombre = document.getElementById('swal_nombre_cliente').value;
            const tipoid = document.getElementById('swal_tipoid_cliente').value;
            const nit = document.getElementById('swal_nit_cliente').value;
            const direccion = document.getElementById('swal_direccion_cliente').value;
            
            // Validar nombre (obligatorio)
            if (!nombre.trim()) {
                Swal.showValidationMessage('El nombre del cliente es requerido');
                return false;
            }
            
            // Validar NIT/CUI/PASAPORTE (obligatorio)
            if (!nit.trim()) {
                const tipoTexto = tipoid === '1' ? 'NIT' : tipoid === '2' ? 'CUI' : 'PASAPORTE';
                Swal.showValidationMessage(`El ${tipoTexto} es requerido`);
                return false;
            }
            
            // Validar dirección (obligatoria)
            if (!direccion.trim()) {
                Swal.showValidationMessage('La dirección es requerida');
                return false;
            }
            
            return {
                nombre: nombre.trim(),
                tipoid: tipoid,
                nit: nit.trim(),
                direccion: direccion.trim()
            };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const datos = result.value;
            
            // Establecer cliente mostrador con tipo 2
            establecerCliente(
                0, // ID 0 para mostrador
                datos.nombre,
                datos.tipoid,
                datos.nit,
                datos.direccion,
                2 // Tipo 2 = Cliente Mostrador
            );
        }
    });
}

/**
 * Actualiza la interfaz para mostrar el cliente seleccionado
 */
function mostrarClienteSeleccionado() {
    // Ocultar botón de seleccionar
    document.getElementById('btnSeleccionarClienteContainer').classList.add('d-none');
    
    // Mostrar información del cliente
    document.getElementById('clienteSeleccionadoContainer').classList.remove('d-none');
    
    // Actualizar los datos mostrados
    const nombreElemento = document.getElementById('nombreClienteMostrar');
    if (tipo_cliente_seleccionado === 1) {
        // Cliente Registrado: Mostrar nombre con burbuja de ID
        nombreElemento.innerHTML = `${nombre_cliente_seleccionado.value} <span class="badge badge-primary badge-pill ml-1" style="font-size: 0.7em; vertical-align: middle; position: relative; top: -1px;">ID: ${id_cliente_seleccionado.value}</span>`;
    } else {
        // Cliente Mostrador: Solo mostrar nombre
        nombreElemento.textContent = nombre_cliente_seleccionado.value;
    }
    document.getElementById('nitClienteMostrar').textContent = nit_cliente_seleccionado.value;
    document.getElementById('direccionClienteMostrar').textContent = direccion_cliente_seleccionado.value;
    
    // Determinar tipo de cliente basado en la variable tipo_cliente_seleccionado
    let tipoTexto = "Sin definir";
    if (tipo_cliente_seleccionado === 1) {
        tipoTexto = "Registrado";
    } else if (tipo_cliente_seleccionado === 2) {
        tipoTexto = "Mostrador";
    }
    document.getElementById('tipoClienteMostrar').textContent = tipoTexto;
    
    // Actualizar el label del tipo de documento dinámicamente
    const tipoDocumento = tipoid_cliente_seleccionado.value;
    let labelDocumento = "NIT";
    switch(tipoDocumento) {
        case '1':
            labelDocumento = "NIT";
            break;
        case '2':
            labelDocumento = "CUI";
            break;
        case '3':
            labelDocumento = "PASAPORTE";
            break;
    }
    document.getElementById('labelTipoDocumento').textContent = labelDocumento;

    // Controlar visibilidad del botón "Editar Cliente" según el tipo
    const btnEditarCliente = document.getElementById('btnEditarCliente');
    if (tipo_cliente_seleccionado === 1) {
        // Cliente Registrado: Ocultar botón de editar
        btnEditarCliente.style.display = 'none';
    } else if (tipo_cliente_seleccionado === 2) {
        // Cliente Mostrador: Mostrar botón de editar
        btnEditarCliente.style.display = 'inline-block';
    }

    area_estadocliente.innerHTML = "";
    if (tipo_cliente_seleccionado === 1) {
        verStatusCliente(id_cliente_seleccionado.value);
    }

}

/**
 * Actualiza la interfaz para ocultar el cliente seleccionado
 */
function ocultarClienteSeleccionado() {
    // Mostrar botón de seleccionar
    document.getElementById('btnSeleccionarClienteContainer').classList.remove('d-none');
    
    // Ocultar información del cliente
    document.getElementById('clienteSeleccionadoContainer').classList.add('d-none');
    
    // Resetear visibilidad del botón editar
    const btnEditarCliente = document.getElementById('btnEditarCliente');
    if (btnEditarCliente) {
        btnEditarCliente.style.display = 'inline-block';
    }
}

/**
 * Función para editar el cliente actual
 */
function editarCliente() {
    if (tipo_cliente_seleccionado === 2) {
        // Si es cliente mostrador, abrir formulario de edición
        crearClienteMostrador();
    } else if (tipo_cliente_seleccionado === 1) {
        // Los clientes registrados NO se pueden editar
        Swal.fire({
            title: 'Cliente Registrado',
            text: 'Los clientes registrados no pueden ser editados desde este módulo.',
            icon: 'info',
            confirmButtonText: 'Entendido',
            customClass: {
                popup: 'swal2-small'
            }
        });
    }
}

/**
 * Función para eliminar/quitar el cliente seleccionado
 */
function eliminarCliente() {
    Swal.fire({
        title: '¿Quitar Cliente?',
        text: '¿Está seguro que desea quitar el cliente seleccionado?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Sí, quitar',
        cancelButtonText: 'Cancelar',
        customClass: {
            popup: 'swal2-small',
            confirmButton: 'btn btn-danger btn-sm mx-1',
            cancelButton: 'btn btn-secondary btn-sm mx-1'
        },
        buttonsStyling: false,
        width: '350px',
        padding: '1rem'
    }).then((result) => {
        if (result.isConfirmed) {
            // Limpiar datos del cliente
            limpiarDatosCliente();
            
            // Actualizar interfaz
            ocultarClienteSeleccionado();
        }
    });
}

/**
 * Limpia todos los datos del cliente seleccionado
 */
function limpiarDatosCliente() {
    tipo_cliente_seleccionado = 0; // Resetear tipo de cliente
    id_cliente_seleccionado.value = "0";
    nombre_cliente_seleccionado.value = "Nombre del Cliente";
    tipoid_cliente_seleccionado.value = "1";
    nit_cliente_seleccionado.value = "CF";
    direccion_cliente_seleccionado.value = "Direccion del Cliente";
}

/**
 * Establece los datos del cliente y actualiza la interfaz
 */
function establecerCliente(id, nombre, tipoid, nit, direccion, tipoCliente = 1) {
    tipo_cliente_seleccionado = tipoCliente; // 1 = registrado, 2 = mostrador
    id_cliente_seleccionado.value = id;
    nombre_cliente_seleccionado.value = nombre;
    tipoid_cliente_seleccionado.value = tipoid;
    nit_cliente_seleccionado.value = nit;
    direccion_cliente_seleccionado.value = direccion;
    
    // Actualizar interfaz
    mostrarClienteSeleccionado();
}

/**
 * Actualiza la interfaz basada en el estado de tipo_cliente_seleccionado
 */
function actualizarInterfazCliente() {
    if (tipo_cliente_seleccionado > 0) {
        mostrarClienteSeleccionado();
    } else {
        ocultarClienteSeleccionado();
    }
}

/**
 * Toggle para minimizar/expandir los detalles del cliente
 */
function toggleMinimizarCliente() {
    const detallesExpandibles = document.getElementById('clienteDetallesExpandibles');
    const detallesExpandibles2 = document.getElementById('clienteDetallesExpandibles2');
    const iconToggle = document.getElementById('iconToggleCliente');
    
    // Verificar si está oculto usando getComputedStyle o verificando si display es 'none'
    const isHidden = detallesExpandibles.style.display === 'none' || 
                     window.getComputedStyle(detallesExpandibles).display === 'none';
    
    if (isHidden) {
        // Expandir
        detallesExpandibles.style.display = 'block';
        detallesExpandibles2.style.display = 'block';
        iconToggle.classList.replace('fa-plus', 'fa-minus' );
        document.getElementById('btnToggleCliente').title = 'Minimizar Cliente';
    } else {
        // Minimizar
        detallesExpandibles.style.display = 'none';
        detallesExpandibles2.style.display = 'none';
        //iconToggle.className = 'fas fa-plus';
        iconToggle.classList.replace('fa-minus', 'fa-plus');
        document.getElementById('btnToggleCliente').title = 'Expandir Cliente';
    }
    
}

// ============================================
// INICIALIZACIÓN DE ESTADO DE CLIENTE
// ============================================

// Verificar estado inicial del cliente al cargar la página
document.addEventListener('DOMContentLoaded', function() {
    // Si hay un cliente válido seleccionado basado en tipo_cliente_seleccionado
    actualizarInterfazCliente();
});