<?php
session_start();
class Admin extends Controller
{
    private $id_usuario;
    public function __construct()
    {
        session_start();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        parent::__construct();
        $this->id_usuario = $_SESSION['id_usuario'];
    }

    public function index()
    {
        $data=[];
        //$data['usuarios'] = $this->model->getData('usuarios');
        //$data['clientes'] = $this->model->getData('clientes');
        //$data['productos'] = $this->model->getData('productos');
        //$data['proveedor'] = $this->model->getData('proveedor');
        //$data['marcas'] = $this->model->getData('marcas');
        //$data['categorias'] = $this->model->getData('categorias');
        //$data['ventas'] = $this->model->ventasCompras('ventas', $this->id_usuario);
        //$data['compras'] = $this->model->ventasCompras('compras', $this->id_usuario);
        //$data['empresa'] = $this->model->getEmpresa();
        if ((int)$_SESSION['tipousuario'] < 3)
        {
            //$data['sucursales']=$this->model->getSucursales();
            $data['vendedores']=$this->model->getVendedores();
            $data['categorias']=$this->model->getCategorias();        
            $data['scripts'] = array(
                array('script' => 'moment.min.js'),         
                array('script' => 'chart.min.js'),
                array('script' => 'pages/home.js')
            );        

            $this->views->getView('admin', 'home', $data);

            } else {

            $this->views->getView('templates', 'noaccess', $data);
        }

    }

    public function inicio()
    {
        //$data['usuarios'] = $this->model->getData('usuarios');
        //$data['clientes'] = $this->model->getData('clientes');
        //$data['productos'] = $this->model->getData('productos');
        //$data['proveedor'] = $this->model->getData('proveedor');
        //$data['marcas'] = $this->model->getData('marcas');
        //$data['categorias'] = $this->model->getData('categorias');
        //$data['ventas'] = $this->model->ventasCompras('ventas', $this->id_usuario);
        //$data['compras'] = $this->model->ventasCompras('compras', $this->id_usuario);
        //$data['empresa'] = $this->model->getEmpresa();
        $data['categorias']=$this->model->getCategorias();                
        $data['scripts'] = array(
            array('script' => 'chart.min.js'),
            array('script' => 'pages/home.js')
        );
        $this->views->getView('admin', 'home', $data);
    }

    public function datos()
    {
        $data['empresa'] = $this->model->getEmpresa();
        $data['scripts'] = array(
            array('script' => 'pages/admin.js')
        );
        $this->views->getView('admin', 'admin', $data);
    }

    public function cambiarEmpresa()
    {
        $identidad = strClean($_POST['identidad']);
        $nombre = strClean($_POST['nombre']);
        $telefono = strClean($_POST['telefono']);
        $direccion = strClean($_POST['direccion']);
        $mensaje = strClean($_POST['mensaje']);
        $impuesto = strClean($_POST['impuesto']);
        $correo = strClean($_POST['correo']);
        $smtp = strClean($_POST['smtp']);
        $clave_smtp = strClean($_POST['clave_smtp']);
        $usuario_smtp = strClean($_POST['usuario_smtp']);
        $puerto_smtp = strClean($_POST['puerto_smtp']);
        $color_header = strClean($_POST['color_header']);
        $color_navbar = strClean($_POST['color_navbar']);
        $id = strClean($_POST['id']);
        if (
            empty($identidad) || empty($nombre) || empty($telefono) || empty($direccion)
            || empty($smtp) || empty($clave_smtp) || empty($correo) || empty($usuario_smtp) || empty($puerto_smtp)
        ) {
            $msg = array('msg' => 'Todo los campos con * son requeridos', 'icono' => 'warning');
        } else {
            $img = $_FILES['imagen'];
            $name = $img['name'];
            $tmpname = $img['tmp_name'];
            $imgNombre = 'logo.png';
            $destino = "Assets/img/" . $imgNombre;
            $data = $this->model->modificarDatos($identidad, $nombre, $telefono, $correo, $direccion, $mensaje, $impuesto, $smtp, $usuario_smtp, $clave_smtp, $puerto_smtp, $color_header, $color_navbar, $id);
            if ($data == 'ok') {
                if (!empty($name)) {
                    move_uploaded_file($tmpname, $destino);
                }
                $msg = array('msg' => 'Datos actualizados', 'icono' => 'success');
                $_SESSION['color_header'] = $color_header;
                $_SESSION['color_navbar'] = $color_navbar;
            } else {
                $msg = array('msg' => 'Error al actualizar', 'icono' => 'error');
            }
        }

        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function stock_minimo()
    {
        $data = $this->model->selectStockM();
        echo json_encode($data);
    }

    public function productos()
    {
        $data = $this->model->selectProductos();
        echo json_encode($data);
    }

    public function comparacionAbonosVentasMes($anio)
    {
        $desde = $anio . '-01-01 00:00:00';
        $hasta = $anio . '-12-31 23:59:59';

        $rec_desde = $anio . '-01-01';
        $rec_hasta = $anio . '-12-31';        

        $id_user = $this->id_usuario;
        $data['ventas'] = $this->model->ingresos('ventas', $desde, $hasta, $id_user);
        $data['abonos'] = $this->model->ingresosabonos('abonos', $rec_desde, $rec_hasta, $id_user);
        echo json_encode($data);
        die();
    }

    public function comparacionVentasVendedor($datos)
    {
        list($anio,$sucursal)=explode(',',$datos);
        list($desde,$hasta)=explode('_',$anio);
        $data['ventas'] = $this->model->ingresosVendedor('ventas', $desde, $hasta, $sucursal);
        
        echo json_encode($data);
        die();
    }
    
    public function comparacionVentasOperador($datos)
    {
        list($anio,$sucursal)=explode(',',$datos);
        list($desde,$hasta)=explode('_',$anio);
        $data['ventas'] = $this->model->ingresosOperador('ventas', $desde, $hasta, $sucursal);
        
        echo json_encode($data);
        die();
    }


    public function comparacionVentasCategoria($datos)
    {
        list($anio,$sucursal)=explode(',',$datos);
        list($desde,$hasta)=explode('_',$anio);
        //var_dump($anio,$sucursal);
        /*$desde = $anio . '-01-01';
        $hasta = $anio . '-12-31';*/
        $id_user = $this->id_usuario;
        $data['ventas'] = $this->model->ingresosCategoria('ventas', $desde, $hasta, $sucursal);
        
        echo json_encode($data);
        die();
    }


    public function comparacionVentasDepartamento($datos)
    {
        list($anio,$sucursal)=explode(',',$datos);
        list($desde,$hasta)=explode('_',$anio);
        //var_dump($anio,$sucursal);
        /*$desde = $anio . '-01-01';
        $hasta = $anio . '-12-31';*/
        $id_user = $this->id_usuario;
        $data['ventas'] = $this->model->ingresosDepartamento('ventas', $desde, $hasta, $sucursal);
        
        echo json_encode($data);
        die();
    }


    public function comparacionVentasMes($anio)
    {
        $desde = $anio . '-01-01';
        $hasta = $anio . '-12-31';
        $id_user = $this->id_usuario;
        $data['ventas'] = $this->model->ingresos('ventas', $desde, $hasta, $id_user);
        echo json_encode($data);
        die();
    }
    public function comparacionVentasSucursalAno($anio)
    {
        $desde = $anio . '-01-01';
        $hasta = $anio . '-12-31';
        $id_user = $this->id_usuario;
        $data=$this->model->ingresosSucursal('ventas', $desde, $hasta, 1);
        echo json_encode($data);
        die();
    }
    
    public function comparacionVentasSucursalMensual($anio)
    {
        list($desde,$hasta)=explode('_',$anio);
        //$desde = $anio . '-01-01';
        //$hasta = $anio . '-12-31';
        $id_user = $this->id_usuario;
        $data=$this->model->ingresosSucursalMes('ventas', $desde, $hasta, 1);
        echo json_encode($data);
        die();
    }

    public function actualizarGrafico($anio)
    {
        $desde = $anio . '-01-01 00:00:00';
        $hasta = $anio . '-12-31 23:59:59';
        $id_user = $this->id_usuario;
        $data['ventas'] = $this->model->ingresos('ventas', $desde, $hasta, $id_user);
        $data['abonos'] = $this->model->ingresos('abonos', $desde, $hasta, $id_user);
        echo json_encode($data);
        die();
    }

    public function actualizarGraficoDia($dia)
    {
        $id_user = $this->id_usuario;
        $data['ventas'] = $this->model->ingresosDia('ventas', $dia, $id_user);
        $data['abonos'] = $this->model->ingresosDia('abonos', $dia, $id_user);
        echo json_encode($data);
        die();
    }

    public function permisos()
    {
        $this->views->getView('admin', 'permisos');
    }

    public function tipoReporte($nombre)
    {
        if ($nombre == 'ticket') {
            $_SESSION['ticket'] = true;
        }else{
            $_SESSION['ticket'] = false;
        }
        $msg = array('msg' => 'Tipo de reporte cambiado', 'icono' => 'success');
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
}
