<?php
class Creditocompras extends Controller
{
    private $id_usuario;
    public function __construct()
    {
        session_start();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        parent::__construct();
        $this->id_usuario = $_SESSION['id_usuario'];
    }
    //Creditos compras
    public function index()
    {
        $data['scripts'] = array(
            array('script' => 'fechas.js'),
            array('script' => 'pages/credito-compras.js')
        );
        $this->views->getView('compras', "creditos", $data);
    }
    public function listar()
    {
        $data = $this->model->getCreditos($this->id_usuario);
        for ($i = 0; $i < count($data); $i++) {
            $estado = ($data[$i]['estatus'] == 0) ? 2 : $data[$i]['estado'];
            if ($estado == 1) {
                $data[$i]['estado'] = '<span class="badge badge-warning">PENDIENTE</span>';
                $data[$i]['acciones'] = '<div class="d-flex">
                        <button class="btn btn-primary" type="button" onclick="nuevo_Abono(' . $data[$i]['id'] . ');"><i class="far fa-credit-card"></i></button>
                        <a class="btn btn-danger" href="' . base_url . 'creditocompras/pdfCredito/' . $data[$i]['id'] . '" target="_blank"><i class="fas fa-file-pdf"></i></a>
                    <div/>';
            }else if ($estado == 2) {
                $data[$i]['estado'] = '<span class="badge badge-warning">ANULADO</span>';
                $data[$i]['acciones'] = '<div class="d-flex">
                        <a class="btn btn-danger" href="' . base_url . 'creditocompras/pdfCredito/' . $data[$i]['id'] . '" target="_blank"><i class="fas fa-file-pdf"></i></a>
                    <div/>';
            } else {
                $data[$i]['estado'] = '<span class="badge badge-success">Finalizado</span>';
                $data[$i]['acciones'] = '<div>
                        <a class="btn btn-danger" href="' . base_url . 'creditocompras/pdfCredito/' . $data[$i]['id'] . '" target="_blank"><i class="fas fa-file-pdf"></i></a>
                    <div/>';
            }
        }
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function abonar(int $id)
    {
        $data = $this->model->getAbono($id);
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function registrarAbono()
    {
        $monto = strClean($_POST['monto']);
        $id = strClean($_POST['id']);
        $id_proveedor = strClean($_POST['id_proveedor']);
        $fecha = date('Y-m-d');
        $hora = date('H:i:s');
        if (empty($monto) || empty($id)) {
            $msg = array('msg' => 'Los campos con * son requeridos', 'icono' => 'error');
        } else {
            $data = $this->model->registrarAbono($id, $id_proveedor, $monto, $fecha, $hora, $this->id_usuario);
            if ($data > 0) {
                $credito = $this->model->getAbono($id);
                $abonado = $credito['abonado'] + $monto;
                $restante = $credito['monto'] - $abonado;
                $abono = $this->model->actualizarCredito('creditos_compras', $abonado, $restante, $id);
                if ($abono == 'ok') {
                    if ($restante == 0) {
                        $this->model->estado('creditos_compras', 0, $id);
                        $compra = $this->model->estadoCompra($id);
                        $this->model->estado('compras', 2, $compra['compra']);
                    }
                    $msg = array('msg' => 'Abono registrado', 'icono' => 'success', 'id' => $data);
                }
            } else {
                $msg = array('msg' => 'Error al registrar el abono', 'icono' => 'error');
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function pdfCredito($id)
    {
        $detalle = $this->model->detalleCredito($id);
        if (!empty($detalle)) {
            # code...
            $data['abonos'] = $this->model->detalleAbono($id);
            $data['credito'] = $this->model->detalleProveedor($id);
            $data['empresa'] = $this->model->getEmpresa();

            ob_start();
            $html = $this->views->getView('compras', "reporte-credito", $data);
            $html = ob_get_clean();
            require_once 'vendor/autoload.php';
            $mpdf = new \Mpdf\Mpdf();
            if ($data['credito']['estatus'] == 0) {
                $mpdf->SetWatermarkImage('Assets/img/anulado.png');
                $mpdf->showWatermarkImage = true;
            }
            // $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
            $mpdf->WriteHTML($html);
            $mpdf->Output();
        } else {
            header('location: ' . base_url . 'creditos');
        }
    }
    public function pdfAbono($id)
    {

        $data['abono'] = $this->model->datoAbono($id);
        $data['empresa'] = $this->model->getEmpresa();
        ob_start();
        $html = $this->views->getView('compras', "ticket-abono", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf([
            'mode' => 'utf-8',
            'format' => [48, 210],
            'margin_left' => 2,
            'margin_right' => 2,
            'margin_top' => 0,
            'margin_bottom' => 0
        ]);
        $mpdf->SetWatermarkImage('Assets/img/logo.png');
        $mpdf->showWatermarkImage = true;
        // $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
        $mpdf->WriteHTML($html);
        $mpdf->Output();
    }
    public function abonos()
    {
        $data['scripts'] = array(
            array('script' => 'fechas.js'),
            array('script' => 'pages/abono-compras.js')
        );
        $this->views->getView('compras', "abonos", $data);
    }
    public function listar_abonos()
    {
        $data = $this->model->getAbonos($this->id_usuario);
        for ($i = 0; $i < count($data); $i++) {
            $data[$i]['nombre'] = ' Credito N°: ' . $data[$i]['id_credito'] . ' ___ ' . $data[$i]['nombre'];
            $data[$i]['acciones'] = '<div>
                    <a class="btn btn-danger" href="' . base_url . 'creditocompras/pdfAbono/' . $data[$i]['id'] . '" target="_blank"><i class="fas fa-file-pdf"></i></a>
                <div/>';
        }
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }
}
