<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte</title>
    <link rel="stylesheet" href="<?php echo base_url . 'Assets/css/reporte.css'; ?>">
</head>

<body>
    <table id="datos-empresa">
        <tr>
            <td class="logo">
                <img src="<?php echo base_url . 'Assets/img/logo.png'; ?>" alt="" width="150">
            </td>
            <td class="info-empresa">
                <p><b><?php echo $data['empresa']['nombre']; ?></b></p>
                <hr>
                <p><b>NIT:</b> <?php echo $data['empresa']['identidad']; ?></p>
                <p><b>TELEFONO:</b> <?php echo $data['empresa']['telefono']; ?></p>
                <p><b>DIRECCION:</b> <?php echo $data['empresa']['direccion']; ?></p>
            </td>
            <td class="info-detalle">
                <h4>ORDEN DE COMPRA</h4>
                <p>N°: <strong><?php echo $data['compra']['id']; ?></strong></p>
                <p>Fecha: <?php echo $data['compra']['fecha']; ?></p>
                <p>Hora: <?php echo $data['compra']['hora']; ?></p>
            </td>
        </tr>
    </table>


    <h5 class="title">Datos del Proveedor</h5>
    <table id="container-info">
        <tr>
            <td colspan="2">
                <strong>Nombre: </strong>
                <p><?php echo $data['compra']['nombre'] ?></p>
            </td>
        </tr>
        <tr>
            <td>
                <strong>Teléfono: </strong>
                <p><?php echo $data['compra']['telefono'] ?></p>
            </td>
            <td>
                <strong>Dirección: </strong>
                <p><?php echo $data['compra']['direccion'] ?></p>
            </td>
        </tr>
    </table>
    <h5 class="title">Detalle de los Productos</h5>
    <table id="container-producto">
        <thead>
            <tr>
                <th class="text-left">Cant</th>
                <th class="text-left">Descripción</th>
<!--                <th class="text-right">Precio</th>
                <th class="text-right">SubTotal</th>
-->                
            </tr>
        </thead>
        <tbody>
            <?php
            $descuento = 0;
            foreach ($data['detalle'] as $producto) {
                $descuento += $producto['descuento']; ?>
                <tr>
                    <td><?php echo $producto['cantidad']; ?></td>
                    <td><?php echo $producto['descripcion']; ?></td>
<!--                    <td class="text-right"><?php echo number_format($producto['precio'], 2); ?></td>
                    <td class="text-right"><?php echo number_format($producto['cantidad'] * $producto['precio'], 2); ?></td>
-->                    
                </tr>
            <?php } ?>
            <tr>
                <td>
                </td>
            </tr>
<!--            <tr class="total">
                <td class="text-right" colspan="3">Descuento</td>
                <td class="text-right"><?php echo number_format($descuento, 2); ?></td>
            </tr>
            <tr class="total">
                <td class="text-right" colspan="3">Total</td>
                <td class="text-right"><?php echo number_format($data['compra']['total'], 2); ?></td>
            </tr>
            -->            
        </tbody>
    </table>
    <div class="mensaje">
        <?php echo $data['empresa']['mensaje']; ?>
        <hr style='margin-bottom:5px;'>
        <?php echo nl2br($data['compra']['anotacion']); ?>
    </div>

</body>

</html>